__doc__ = """SQL Blender Column

$Id: SQLBColumn.py,v 1.1 2001/09/05 03:05:32 andy Exp $"""
__version__ = "$Id: SQLBColumn.py,v 1.1 2001/09/05 03:05:32 andy Exp $"[11:-2]

import os
from Globals import HTMLFile, DTMLFile
from OFS import SimpleItem, PropertyManager, PropertySheets

manage_addSQLBColumnForm = HTMLFile(
    os.path.join('dtml', 'manage_addSQLBColumnForm'), globals())

def manage_addSQLBColumn(self, id="", title="", table="", column="",
                         AS="", label="", REQUEST=None):
    """Add a SQL Blender Column."""
    c = SQLBColumn(id, title, table, column, AS, label)
    self._setObject(c.id, c)
    if REQUEST is not None: return self.manage_main(self, REQUEST)

class SQLBColumn(
    PropertyManager.PropertyManager,
    SimpleItem.SimpleItem
    ):

    "SQL Blender Column"

    meta_type = "SQLB Column"
    _properties = (
        { 'id': 'title', 'type': 'string',},
        { 'id': 'table', 'type': 'string', 'mode': 'w'},
        { 'id': 'column', 'type': 'string', 'mode': 'w'},
        { 'id': 'AS', 'type': 'string', 'mode': 'w'},
        { 'id': 'label', 'type': 'string', 'mode': 'w'},
        { 'id': 'field_type', 'type': 'string', 'mode': 'w'},
        { 'id': 'scale', 'type': 'int', 'mode': 'w'},
        { 'id': 'precision', 'type': 'int', 'mode': 'w'},
        { 'id': 'default', 'type': 'string', 'mode': 'w'},
        { 'id': 'PRIMARY_KEY', 'type': 'boolean', 'mode': 'w'},
        { 'id': 'INDEX', 'type': 'boolean', 'mode': 'w'},
        { 'id': 'UNIQUE', 'type': 'boolean', 'mode': 'w'},
        { 'id': 'NOT_NULL', 'type': 'boolean', 'mode': 'w'},
        { 'id': 'FOREIGN_KEY', 'type': 'string', 'mode': 'w'},
        { 'id': 'read_only', 'type': 'boolean', 'mode': 'w'},
        { 'id': 'read_expr', 'type': 'string', 'mode': 'w'},
        { 'id': 'write_expr', 'type': 'string', 'mode': 'w'},
        { 'id': 'form_input', 'type': 'text', 'mode': 'w'},
        { 'id': 'formatted_value', 'type': 'string', 'mode': 'w'},
        { 'id': 'missing_value', 'type': 'string', 'mode': 'w'},
        { 'id': 'null_value', 'type': 'string', 'mode': 'w'},
        { 'id': 'display_column', 'type': 'string', 'mode': 'w'},
        { 'id': 'display_column_order', 'type': 'string', 'mode': 'w'},
        )
        
    def __init__(self,
                 id='',
                 title='',
                 table='',
                 column='',
                 AS='',
                 label='',
                 field_type='',
                 scale=0,
                 precision=0,
                 default='',
                 PRIMARY_KEY=0,
                 INDEX=0,
                 UNIQUE=0,
                 NOT_NULL=0,
                 FOREIGN_KEY='',
                 ):
        self.propertysheets = PropertySheets.DefaultPropertySheets()
        self.title = title
        self.table = table
        self.column = column
        self.id = id or AS or self.column_reference()
        self.AS = AS
        self.label = label
        self.field_type = field_type
        self.scale = scale
        self.precision = precision
        self.default = default
        self.PRIMARY_KEY = PRIMARY_KEY
        self.INDEX = INDEX
        self.UNIQUE = UNIQUE
        self.NOT_NULL = NOT_NULL
        self.FOREIGN_KEY = FOREIGN_KEY
        self.read_only = 0
        self.read_expr = ''
        self.write_expr = ''
        self.form_input = ''
        self.formatted_value = ''
        self.missing_value = ''
        self.null_value = ''
        self.display_column = ''
        self.display_column_order = ''

    def column_reference(self):
        if self.table:
            return "%s.%s" % (self.table, self.column)
        else:
            return self.column

    def column_identifier(self):
        return self.AS or \
               (self.table and "%s.%s" % (self.table, self.column)) or \
               self.column
    
    def read_column_reference(self):
        colref = self.search_column_reference()
        if self.AS:
            return "%s AS %s" % (colref, self.AS)
        else:
            return colref

    def search_column_reference(self):
        return self.read_expr or self.column_reference()

    def write_column_reference(self):
        return self.write_expr or self.column_reference()

    def sqlvar_field_type(self):
        if self.field_type in ('int','float', 'string', 'nb'):
            return self.field_type
        else: return 'string'
    
    def sqltest_field_type(self):
        if self.field_type in ('int','float'):
            return self.field_type
        else: return 'nb' # XXX
    
    def sqltest(self, mandatory=0):
        if mandatory:
             f = '<dtml-sqltest %s column="%s" type=%s>'
        else:
             f = '<dtml-sqltest %s column="%s" type=%s optional>'
        s = f % (self.column_identifier(), self.search_column_reference(),
                 self.sqltest_field_type())
        return s

    def sqlvar(self, mandatory=0):
        if mandatory or self.NOT_NULL:
            s = '<dtml-sqlvar %s column="%s" type=%s>' \
                % (self.column, self.search_column_reference(),
                   self.sqlvar_field_type())
        else:
            s = '<dtml-sqlvar %s column="%s" type=%s optional>' \
                % (self.column, self.search_column_reference(),
                   self.sqlvar_field_type())
        return s

    def ZSQL_arg_base(self):
        return "%s:%s" % (self.column, self.sqlvar_field_type())

    def ZSQL_SELECT_arg(self):
        return "%s:%s:optional" \
                   % (self.column_identifier(), self.sqlvar_field_type())

    def ZSQL_UPDATE_arg(self):
        if self.default:
            return '%s:%s="%s"' % \
                   (self.column,
                    self.sqlvar_field_type(),
                    self.default)
        else:
            return self.ZSQL_SELECT_arg()

    def ZSQL_INSERT_arg(self):
        if self.NOT_NULL:
            return '%s:%s' % \
                   (self.column,
                    self.sqlvar_field_type())
        else:
            return self.ZSQL_UPDATE_arg()

    def INSERT_sqlvar(self, mandatory=0):
        if self.read_only: return ''
        if self.NOT_NULL or self.write_expr:
            t = '<dtml-sqlvar %s type=%s>' \
                % (self.column,
                   self.sqlvar_field_type())
            if self.write_expr:
                s = self.write_expr % t
            else:
                s = t
        else:
            if mandatory:
                f = '<dtml-sqlvar %s type=%s>'
            else:
                f = '<dtml-sqlvar %s type=%s optional>'
            s = f % (self.column, self.sqlvar_field_type())
        return s

    def table_heading_text(self):
        return self.label or self.column_identifier()

    def table_heading(self):
        a = getattr(self, 'TH_attr', '')
        if a:
            a = ' '+a
        text = self.table_heading_text()
        t, c = self.foreign_key()
        url = ''
        if t and c:
            url = "&dtml.url-%s;/list" % t
        if url: text = '<A href="%s">%s</A>' % (url, text)
        return "<TH%s>%s</TH>" % (a, text)

    def dtml_var(self):
        if self.formatted_value: return self.formatted_value
        var = self.dtml_var_edit()
        t, c = self.foreign_key()
        if t and c:
           var = '<A href="&dtml.url-%s;/SELECT/%s/&dtml-%s;/show">%s</A>' % \
                   (t, c, self.column_identifier(), var)
        return var
        

    def dtml_var_edit(self):
        fmt = ''
        if self.field_type == 'float' and self.scale:
            fmt = ' fmt="%%%d.%df"' % (self.scale, self.precision)
        return "<dtml-var %s %shtml_quote " \
               "missing=\"%s\" null=\"%s\">" % \
               (self.column_identifier(), fmt,
                self.missing_value, self.null_value)
    
    def table_value(self):
        a = getattr(self, 'TD_attr', '')
        if a:
            a = ' '+a
        t, c = self.foreign_key()
        url = ''
        value = "<dtml-var %s html_quote>" % self.column_identifier()
        if t and c:
            url = "&dtml.url-%s;/SELECT/%s/" \
                  "&dtml.url_quote_plus-%s;/show" % \
                  (t, c, self.column_identifier())
        elif self.PRIMARY_KEY:
            url = "SELECT/%s/&dtml.url_quote_plus-%s;/show" % \
                  (self.column_identifier(), self.column_identifier())
        if url: value = '<A href="%s">%s</A>' % (url, value)
        return "<TD%s>%s</TD>" % \
               (a, value)

    def form_input_element(self):
        if self.read_only: return self.dtml_var()
        if self.form_input: return self.form_input % self.dtml_var_edit()
        table, column = self.foreign_key()
        if table and column:
            return '<dtml-with %s>' \
                   '<dtml-var select_%s>' \
                   '</dtml-with>' % \
                   (table, column)
        return '<INPUT name="%s" type="text" value="%s">' % \
               (self.column_identifier(), self.dtml_var_edit())

    def foreign_key(self):
        from string import split
        if self.FOREIGN_KEY:
            table, column = split(self.FOREIGN_KEY,".",1)
            return table,column
        else:
            return None, None

    def select_options_columns(self):
        from string import join
        if self.INDEX:
            me = self.column_identifier()
            other = self.display_column
            order = self.display_column_order or other
            return me, other, order
        return None, None, None
    
