__doc__='''Generic Database Adapter Package Registration

$Id: __init__.py,v 1.2 2001/09/05 05:30:53 andy Exp $'''
__version__='$Revision: 1.2 $'[11:-2]

import sys, string, os
import SQLBlender, SQLBColumn
from Products.ZSQLMethods.SQL import SQLConnectionIDs
from Globals import ImageFile

methods = { 'SQLConnectionIDs': SQLConnectionIDs }
misc_ = { 'SQLBlenderIcon': ImageFile(
    os.path.join('Products','SQLBlender','www','SQLBlender.gif')) }

def initialize(context):
    """Initialize product."""
    context.registerClass(
        SQLBlender.SQLBlender,
        permission = 'Add SQL Blender',
        constructors = (
            SQLBlender.manage_addSQLBlenderForm,
            SQLBlender.manage_addSQLBlender,
        ),
    )

    context.registerClass(
        SQLBColumn.SQLBColumn,
        constructors = (
            SQLBColumn.manage_addSQLBColumnForm,
            SQLBColumn.manage_addSQLBColumn,
        ),
        icon = os.path.join("www","SQLBlender.gif"),
    )

    context.registerHelp()
    context.registerHelpTitle('SQL Blender')

