"""
EMIL EMAIL CLIENT
Copyright (C) 2002  Andreas Prlic
andorsch@gmx.at

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

"""

import emil_register
import email_message
import email_folder
import sms_gateway

def initialize(context): 

    """Initialize the EMIL_Email_Client product.
    This makes the object apear in the product list"""

    # the email class
    
    context.registerClass(
	email_message.Email,
	constructors = (
	email_message.manage_addEmail,	
	),
	icon='img/mail.jpg'
	)

    # the email top folder classs
    
    context.registerClass(
	emil_register.EmailFolder,
	constructors = (
	emil_register.manage_addEMILForm,
	emil_register.manage_addEMILAction,
	),
	icon='img/emil_folder.jpg'
	)

 

    # the default email folder class

    context.registerClass(
	email_folder.email_folder,
	constructors = (
	email_folder.manage_addEmail_Folder_Form,
	email_folder.manage_addEmail_Folder_Action,
	),
	icon=''
	)

    # the sms_gateway class

    context.registerClass(
	sms_gateway.SMS_Gateway,
	constructors = (
	sms_gateway.manage_addForm,
	sms_gateway.manage_addAction,
	),
	icon='img/sms.jpg'
	)








