"""
EMIL EMAIL CLIENT
Copyright (C) 2002  Andreas Prlic
andorsch@gmx.at

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


"""
#import Globals
import OFS
from OFS import SimpleItem

import Globals
from Globals import DTMLFile
#from Globals import Persistent
#import Acquisition                	# Various acquisition types. 
import AccessControl.Role         	# Zope Security management.
#from  Products.ZCatalog.CatalogAwareness import CatalogAware


from email_message import Email




class email_folder(OFS.Folder.Folder) :

    """ the general email folder """

    meta_type = 'Email_Folder'
    folder_options = ((	{'label': 'View_Messages',   'action': 'folder_view_html',},)
		      )
    #(OFS.ObjectManager.ObjectManager.manage_options[0],)+
    manage_options = (folder_options +
		       ( {'label': 'Folder_Properties',  'action': 'folder_manage_edit_Form',},) +
		      AccessControl.Role.RoleManager.manage_options+
		      OFS.SimpleItem.Item.manage_options+
		      OFS.FindSupport.FindSupport.manage_options
		      )
    
    
    __ac_permissions__=(
	('View management screens',['folder_manage_edit_Form',
				    'manage_editAction'], ('Owner',)),
	('View',  	           ['folder_index_html',
				    'folder_view_html'], ('Owner',)),
	('Emil_WAP_access',        ['folder_wml',
				   'view_folders_wml',],	 	('Owner',)),
        )     

    weekdays = ("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday",)
    


    index_html = OFS.Folder.Folder.manage_workspace
    folder_view_html         = DTMLFile('dtml/folder_view_html'        , globals())
    folder_index_html        = DTMLFile('dtml/folder_index_html'       , globals())
    folder_manage_edit_Form  = DTMLFile('dtml/folder_manage_edit_Form' , globals())    

    folder_wml               = DTMLFile('dtml/wap/folder_wml'          , globals())   
    view_folders_wml         = DTMLFile('dtml/wap/view_folders_wml'    , globals())
    
    def __init__ (self, id, title ) :
	""" inits the Folder with default values """
	self.id       = id
	self.title    = title
	self.sms_days = {}
	self.sms_gateway_id = None

	self.my_icon = None
	
    def set_icon(self,id,filename) :
	""" allows to specify an icon which is \
	different from the default one. Usfeull for inbox, outbox
	id should be id of file in zope
	filename the name on the hard disk"""
	
	img = Globals.ImageFile(filename, globals())
	from OFS.misc_ import p_
	ex =  "p_.%s = img" % id
	print ex
	exec ex
	self.icon = "p_/%s" % id

	
    def manage_editAction(self, title,sms_gateway_id=None,REQUEST=None) :
	""" change the product values """

	self.title = title
	self.sms_days = {}
	for day in self.weekdays :
	    if REQUEST.has_key(day) :
		self.sms_days[day] = 1

	self.sms_gateway_id=sms_gateway_id
	
	self._p_changed = 1
	message = "properties have been changed"
	return self.folder_manage_edit_Form(self, REQUEST,manage_tabs_message=message)
    
    def if_sms_on_day(self,day) :

	if self.sms_days.has_key(day) :
	    return 1
	else :
	    return 0
	
    def check_send_sms(self,email) :
	from DateTime import DateTime    
	today = DateTime().strftime('%A')
	if self.if_sms_on_day(today) :
	    self.send_sms(email)

    def send_sms(self,email):
		
	body = email.get_body()
	# add first few lines of email ...
	sms_body = body[:255-len(email['Subject'])]
	#print sms_body
	send_body = "%s:\n%s,\n%s" % (email['From'],email['Subject'],sms_body)
	
	sms_gateway = getattr(self.sms_folder,self.sms_gateway_id)
	sms_gateway.send_SMSAction(mesg=send_body)
	
	
    def get_emails(self) :
	" return list of emails "
	"return emails in current folder"
	return self.objectItems('Email')

    def manage_addEmail(self,id,title,size,uid) :
	" add an email"	
	self._setObject(id,Email(id,title,size,uid))


    def add_DTML(obj,id,title,file):
	path = Globals.package_home(globals())
	f    = open( path + '/' + file + '.dtml')     
	file = f.read()     
	f.close()     
	obj.manage_addDTMLMethod(id,title,file)     
	return getattr(obj,id)
    
manage_addEmail_Folder_Form = DTMLFile('dtml/folder_manage_addEmail_Folder_Form', globals()) 

def manage_addEmail_Folder_Action(self,id,title,REQUEST=None) :
    " add an email folder"	
    self._setObject(id,email_folder(id,title))
    
    
    if REQUEST is not None:
	return self.manage_main(self, REQUEST)
    






