"""
EMIL EMAIL CLIENT
Copyright (C) 2002  Andreas Prlic
andorsch@gmx.at

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


# new in version 0.3 :
	use the python email module (http://www.python.org/doc/lib/module-email.html)

"""


import re
import string

import Globals
import OFS
from OFS import SimpleItem
from Globals import DTMLFile
from DateTime import DateTime    # to create send_mail time

from  Products.ZCatalog.CatalogAwareness import CatalogAware

import email  # use python email library !
from email import _Message
from email import Encoders
from email.MIMEBase import MIMEBase # to add attachments ...
from email.Utils import *

# emails are now catalogAware
class Email(CatalogAware, _Message,SimpleItem.SimpleItem  ):
    "an email message"

    meta_type = "Email"
    manage_options = (
	{'label': 'View',          'action': 'index_html'},	
	{'label': 'Reply',         'action': 'reply_mail'},
	{'label': 'Forward',       'action': 'forward_mail'},
	{'label': 'Show_Header',   'action': 'show_header'},
	)

    __ac_permissions__=(
	('View management screens',['index_html',
				    'email_show_header_html'],  ('Owner',)),
	('Emil_WAP_access',        ['email_wml',],	 	('Owner',)),
	)

    index_html       = DTMLFile('dtml/email_index_html'      , globals())
    email_show_header_html  = DTMLFile('dtml/email_show_header_html' , globals())
    email_wml        = DTMLFile('dtml/wap/email_wml' , globals())
    
    def __init__(self,id,title,size,uid) :
	"initialize an email object"

    	self.id      = id
	self.title   = title
	self.message_str = ""
	
	# should display the correct size of the mail in zope, but does not work :-/
	self.size    = int(size)
	
	# uid = unique id from email server for this message
	# it is used to keep distinguish read / unread messages from server	
	self.uid     = uid

	# at some point status should be displayed for every email
	self.possible_status = ['read', 'unread', \
				'replied', 'forwarded' , \
				'sent', 'queued']
	self.status  = 'unread'
	
	# this object is not an instance of the MEssage objected from the email module!
	# which is coming from the python email module
	# donnot know why this is necessary, but id does not work otherwise :-/
	self._headers = []
	
	
    def from_server_list(self,message_lst):
	" build up the message from a server_lst "
    	message_str = string.join(message_lst,'\n')
	# for debug reasons store message string	
	self.message_str = message_str

	#print message_str
	
	# correctbug if no subject is found ..
	self['Subject'] = ''
		
	# cretes a new object
	email_obj  = email.message_from_string(message_str)
	#print email_obj.getencoding()
	# copy all data  into this object
	for key in email_obj.keys() :
	    del self[key]
	    self[key] = email_obj[key]
	
	payload = email_obj.get_payload()
	
	# is this a problem or a feature of email module ? :
	# if email consists of only one attachment that is the message,
	# an instance is returned, not a list or a string
	# anyways, catch this condition
	if type(payload) !=  type('string') and type(payload) != type(['list',]) :
	    payload = payload.get_payload(decode=1)
	
	self.set_payload(payload)
	#import base64
	# decode
	#self['From'] = email.Utils.decode(self['From'])
	self.title = " %s %s" % (self['From'],self['Subject'])

    def __getattr__(self, name):
	'''get an attribute from the object'''
	
	txt = self.get(name)
	if txt != None :	    
	    return txt
	return _Message.__getattr__(self, name)	

    def has_attachements(self) :
	" returns 1 if the email has attachements "
	if self.is_multipart() :
	    return 1
	else :
	    return 0

    def get_loads(self, message,number=None) :

	lst = []
	for msg in message.get_payload() :
	    if msg.is_multipart() :
		loads = self.get_loads(msg)
		lst = lst + loads
	    else :
		lst.append(msg)
	if number != None :
	    return lst[number]
	return lst
	    
    def number_attachements(self):
	""" returns the number of attachements, '' if there are no """

	if self.has_attachements() :
	    #pay = self.get_payload()
	    pay = self.get_loads(self)	    
	    l = len(pay) - 1
	    return l

	return 0

    def get_attachements(self):
	" returns a list describing the attachements "
	ret = []
	if not self.is_multipart()  :
	    return ret
	else :
	    counter = -1
	    txtcount = 0

	    for msg in self.get_loads(self) :
		counter = counter + 1
		params = msg.get_params()
		type = params[0][0]
		if type == 'text/plain' :
		    if txtcount == 0 :
			# first txtcouunt is body of message
			txtcount = txtcount + 1
			continue
		# append the filename the list
		filename = msg.get_param('name')
		if filename == None :
		    filename = "attachment %s" % counter
		lst = ( ('counter', counter), ('filename', filename),('Content-Type',type),)
		#'counter', counter, 'filename', msg.get_filename(),'Content-Type',type]
		ret.append(lst)
	return ret

    def get_attachement(self, number, REQUEST=None,RESPONSE=None) :
	"returns attachment number #... "
	number = int(number)
	
	#msg = self.get_payload(number)
	msg = self.get_loads(self,number)
	
	params = msg.get_params()
	type = params[0][0]
	RESPONSE.setHeader('Content-Type', type)
	return msg.get_payload(decode=1) 

    def import_attachment(self,number,REQUEST=None,RESPONSE=None) :
	""" import attachment into zope clipboard"""
	number = int(number) 
	
	msg = self.get_loads(self,number) 
	params = msg.get_params()
	type = params[0][0]
	
	# create a unique id for this object	
	id = self.create_unique_id()	
	filename = msg.get_param('name')
	title = filename
	
	file = msg.get_payload(decode=1)
	# check images
	match = re.search('image',type)
	if match != None :
	    self.attachments.manage_addImage(id=id,file=file,title=title,content_type=type)
	else :
	    # check text / html
	    match = re.search('text',type)
	    if match != None :
		self.attachments.manage_addDTMLMethod(id,title=title,file=file)

	    else :
		# others : ad as a general file
		self.attachments.manage_addFile(id,title=title,file=file,content_type=type)
	
	msg = "attachment moved to Attachments folder"
	return self.index_html(self,REQUEST,manage_tabs_message=msg)
	
    def get_body(self) :
	""" returns the body of the messages """

	if self.is_multipart()  :
	   
	    for msg in self.get_loads(self) :		
		params = msg.get_params()
		type = params[0][0]
		if type == 'text/plain' :
		    return msg.get_payload(decode=1)
	    return ""

	else :
	    # simple mail, no attachement
	    #load = self.get_payload(decode=1)
	    return self.get_payload(decode=1)


    def set_values(self,
		   title='',		   
		   status='unread'  ) :
	" set values of an email from outside"
		   
	self.title   = title
	self.set_status(status)

    def set_status(self,status) :
	" change the status of an email" 
	if status in self.possible_status :
	    # only change if status = unread
	    
	    if self.status == 'unread' or self.status == 'queued' :
		self.status = status 
	else :
	    raise "unknown_email_status", "unkown status: %s" % status
	
	return ""

    def get_date(self) :
	""" create correct date string for send mail """
	# get differnece to GMT
	gmt = DateTime().toZone('GMT').strftime('%Y%m%d%H%M')
	loc = DateTime().strftime('%Y%m%d%H%M')
	d = long(loc)- long(gmt) 
	
	
	if d < 0 :
	    diff = "-"
	else :
	    diff = "+"

	d = "0" + str(d)
	# if d > 9 then the leading 0 does not cause problems, \
	# since we only slice from the right:
	diff = diff + d[-4:]
	
	date = str(DateTime().strftime('%a, %d %b %Y %H:%M:%S '))
	return date + diff



    def headers2dictionary(self, text):
        """
        Taking text in the format of a header block convert to a dictionary
        """
	
        last_dict = None
        resultDictionary = {}
        if text != None:
	    
            for each in string.split(text, '\r\n'):
                line = string.split(each, ':')
                if len(line) > 1:
                    last_dict = string.upper(line[0])
                    resultDictionary[string.upper(line[0])] = string.join(line[1:], ':')
                elif len(line[0]) > 1 and line[0][0] in string.whitespace and last_dict is not None:
                    resultDictionary[last_dict] = resultDictionary[last_dict] + line[0][1:]

        return resultDictionary

    def create_attachment(self,attachment) :
	""" creates an attachment """
	
	head_str = str(attachment.headers)
	header = self.headers2dictionary(head_str)	  	    
	cont_type =  string.strip(header['CONTENT-TYPE'])

	#ctype = 'application/octet-stream'
	#maintype, subtype = ctype.split('/', 1)
	atta = _Message()
	atta.add_header('Content-Type',cont_type)
	atta.add_header('Content-Disposition', 'attachment', filename=attachment.filename)
	atta.set_payload(attachment.read())
	Encoders.encode_base64(atta)
       	
	return atta
	
    
	
    def send_mail(self,From,To,Subject,Body, attachment=None ) :
	""" send an email """
	# assume that MailHost is called MailHost :
	self.set_status('queued')

	# build upe email using the email module :
	
	self.add_header('From',From)
	self.add_header('To',To)	
	self.add_header('Subject',Subject)
	self.add_header('User-Agent','Emil_Email_Client')
	date = self.get_date()
	self.add_header('Date',date)

	#self.set_payload(Body)
	#print attachment
	if attachment == None :
	    self.set_payload(Body)

	elif attachment.filename != '' :
	    # there is an attachment...
	    
	    self.preamble = 'You will not see this in a MIME-aware mail reader.\n'
	    # To guarantee the message ends with a newline
	    self.epilogue = ''

	    msg = _Message()
	    msg.add_header('Content-Type','text/plain') 
	    msg.set_payload(Body)
	    self.set_payload(msg)
	    atta = self.create_attachment(attachment)
	    self.add_payload(atta)
	else :
	    # no attachment
	    self.set_payload(Body)
	
	if self.is_multipart() :
	    self.add_header('Content-Type','multipart/mixed')
	else :
	    self.add_header('Content-Type','text/plain') 

	messageText = self.as_string()
	self.MailHost.send(messageText,subject=Subject)
	self.set_status('sent')
	self.title = "%s %s" % (Subject,To)
  
    def reply_mail(self) :
	" reply message "
	# format body to contain ">" reply symbol still missing

	body = self.get_body()

	new_body = "On %s, you wrote:\n" % self.Date
	for line in body.split("\n") :
	    new_body = new_body + ">" + line + "\n"

	pos = string.find("Re: ",self['Subject'])
	if  pos != -1 :
	    # already a re: in subject...
	    new_subject = self['Subject']
	else :
	    new_subject = "Re: %s" % self['Subject']

	# call the write mail dtml document. ( it belongs to email folder )	
	to = self['reply-to']
	if to == None :
	    to = string.replace(self.From,'"','')
	    
	return self.folder_write_mail_html(To=to,Body=new_body,Subject=new_subject)

    def forward_mail(self) :
	""" forward message """

	new_body = "\n-----Forwarded message -------\n\n"
	new_body = new_body + "From: %s\n"    % self['From']
	new_body = new_body + "To: %s\n"      % self['To']
	new_body = new_body + "Date: %s\n"    % self['Date']
	new_body = new_body + "Subject: %s\n\n" % self['Subject']
	body = self.get_body()
	new_body = new_body + body
	new_subject = "Fwd : %s" % self['Subject']
	return self.folder_write_mail_html(Body=new_body,Subject=new_subject)
	

    def show_header(self):
	" show header"

	txt = ""
	
	for part in self.walk() :
	    for item in part.items():
		key   = item[0]
		value = item[1]
		#txt = txt + "%s\t%s\n" % (key,value)
		txt = txt + key + "\t"
		txt = txt + value + "\n"
	    txt = txt + "\n"
	    
	return self.email_show_header_html(header=txt)

    def get_size(self):
	""" return the size of the email ( needed to display size in zope... """
	return self.size

    # html formatting functions    
    
    def change_larger_smaller(self,line) :
	" format < and > symbols to avoid confusin with html tag "
	line = string.replace(line, "<", "&lt;")
	line = string.replace(line, ">", "&gt;")
	return line


    def highlight_links(self,txt):
	" change appeareance of email, urls "
	ret = ""

	for line in string.split(txt,"\n") :
	    # change emails
	    pat = re.findall("([a-zA-Z0-9\._-]*)@([a-zA-Z0-9\._-]*)",line)
	    
	    if  pat != None:
		for group in pat :
		    user  = group[0]
		    server= group[1]
		    str = "%s@%s" % (user,server)
		    # line = string.replace(line,str,'<a href="mailto:%s">%s</a>'% (str,str))
		    repstr = '<a href="folder_write_mail_html?To=%s">%s</a>' % (str,str)
		    line = string.replace(line,str, repstr)
	    # change urls
	    pat2 = re.search("(http://[a-zA-Z:0-9\._\-\/]*)",line)
	    if pat2 != None :
		url = pat2.group(1)
		line = string.replace(line,url,'<a href="%s">%s</a>' % (url,url))
	    ret = ret + line + "\n"

	return ret

    
    
def manage_addEmail(self,id, title='',message_lst='', size=0, uid =None, REQUEST=None) :
    " add a email to Zope "

    self._setObject(id, Email(id,title,size,uid))
    
    if REQUEST is not None: return self.manage_main(self,REQUEST)




	    
	    
		    


