"""
EMIL EMAIL CLIENT
Copyright (C) 2002  Andreas Prlic
andorsch@gmx.at

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


"""
import string

import Globals
import OFS
from OFS import SimpleItem

from Globals import DTMLFile
from Globals import Persistent
import Acquisition                	# Various acquisition types. 
import AccessControl.Role         	# Zope Security management.

from pop_connection import pop_connection
from email_message import Email
from email_folder import email_folder

class EmailFolder(email_folder) :

    """ A EMIL email client product """

    meta_type = 'EMIL_Email_Client'
    #(OFS.ObjectManager.ObjectManager.manage_options[0],)+
    manage_options = (( OFS.ObjectManager.ObjectManager.manage_options[0],)+
		      ({'label': 'Folder_Overview', 'action': 'folder_index_html',},
		       {'label': 'Write_Email', 'action': 'folder_write_mail_html',},
		       {'label': 'Check_Email', 'action': 'check_mail_html',},		      
		       {'label': 'Client_Properties',  'action': 'manage_editForm',},) +
		      AccessControl.Role.RoleManager.manage_options+
		      OFS.SimpleItem.Item.manage_options+
		      OFS.FindSupport.FindSupport.manage_options
		      )

    
    __ac_permissions__=(
	('View management screens',['manage_editForm',
				    'manage_editAction'], 	('Owner',)),
	('Emil_Send_Mail',	   ['folder_write_mail_html',
				    'email_sendAction'],	('Owner',)), 	
	('Emil_Receive_Mail',	   ['check_mail_html',
				    'check_EmailAction'],	('Owner',)),
	('Emil_WAP_access',        ['main_wml',
				    'check_emails_wml'], 	('Owner',)),
        )     

    # The web pages that shows content. Put your own in the dtml folder.

    # Used to view content of the object:
    manage_editForm          = DTMLFile('dtml/emil_manage_editForm' , globals())
    check_mail_html          = DTMLFile('dtml/check_mail_html' , globals())
    folder_write_mail_html   = DTMLFile('dtml/folder_write_mail_html' , globals())

    # called from manage_edit
    add_filter_rule          = DTMLFile('dtml/add_filter_rule' , globals())

    # add wap pages
    main_wml                 = DTMLFile("dtml/wap/main_wml",  globals())
    check_emails_wml         = DTMLFile('dtml/wap/check_emails_wml'    , globals())
    
    def __init__ (self, id, title, server, username, password, get_new, realname='',reply_to='' ) :
	""" inits the EMIL with default values """
	
	self.id       = id
	self.title    = title
	self.server   = server
	self.username = username
	self.password = password
	self.realname = realname
	self.reply_to = reply_to
	
	# uidl keeps track of which emails have been dowloaded from server
	# it is a dictionary of email uid ( see email class)	
	# if no mails are on server, uid can be reset.
	self.uidl = {}

	# get new is a flag to download all emails, or only the new ones
	if get_new == '' :
	    self.get_new =  0
	else :
	    self.get_new = 1

	
	#self.manage_addFolder('Outbox','outgoing email folder')
	self.manage_addEmail_Folder('Inbox','incoming email folder')
	self.manage_addEmail_Folder('Outbox','outgoing email folder')
	self.manage_addFolder('SMS','SMS Gateways')	
	self.manage_addFolder('Attachments','attachments')
	
	# store them
	self.incoming_folder = getattr(self,'Inbox')
	self.outgoing_folder = getattr(self,'Outbox')
	self.sms_folder      = getattr(self,'SMS')
	self.attachments     = getattr(self,'Attachments')
       	
	# set icons	
	self.incoming_folder.set_icon('inbox','img/inbox.jpg')
	self.outgoing_folder.set_icon('outbox','img/outbox.jpg')

	# smsfolder is a normal folder...
	img =  Globals.ImageFile('img/smsfolder.jpg', globals())
	from OFS.misc_ import p_
	p_.sms_folder = img
	self.sms_folder.icon = "p_/sms_folder"
	
	
	
	# the filter rules to spread objects in folders ...
	self.filter_fields = ('From','To','Subject','Body',)
	self.filter_rules = ()

	
	# search for emails ...
	#new_zcatalog=context.manage_addProduct['ZCatalog'].manage_addZCatalog(id='new_id1')
	
    def manage_editAction(self, title, server, username, password, get_new='', realname='',reply_to='' , REQUEST=None,RESPONSE=None) :
	"Changes the product values"

	self.title    = title
	self.server   = server
	self.username = username
	self.password = password

	if get_new == '' :
	    self.get_new =  0
	else :
	    self.get_new = 1

	self.realname = realname
	self.reply_to = reply_to
	
	self._p_changed = 1
	#RESPONSE.redirect('manage_editForm')
	message = "properties have been changed"
	return self.manage_editForm(self, REQUEST,manage_tabs_message=message)


    def get_email_stats(self):
	"return # email / folder "
	ret = []
	for folder in self.objectValues('Email_Folder') :
	    
	    email_lst = folder.objectValues('Email')
	    unread_count = 0
	    for email in email_lst :
		if email.status == 'unread' :
		    unread_count = unread_count + 1
	    lst = []
	    fo = ('folder',folder.id)
	    to = ('total',len(email_lst))
	    un = ('unread',unread_count)
	    lst.append(fo)
	    lst.append(to)
	    lst.append(un)
	   
	    ret.append(lst)
	return ret

    def reset_uidl(self) :
	" reset the uid dictionary, only do this when there are no mails on server... "
	self.uidl = {}

    def check_EmailAction(self,return_flag=0,REQUEST=None) :
	"""checks the email
	return_flag can be 0 for no return,
	'index' for returning index_html
	or 'sms' for returning a message"""
	
	pop = pop_connection(server=self.server,user=self.username,password=self.password)
	pop.open()
	
	number_mails, octet =  pop.status()	
	# no mails on server, uidl can be reset
	if number_mails == 0 :
	    self.reset_uidl()
	    message= "no mails on server"
	    return self.manage_main(self, REQUEST,manage_tabs_message=message)

	messages = pop.get_messages(get_new=self.get_new,known_uidl=self.uidl)
	pop.close()

	txt = ""
	
	c = 0
	for message in messages :	    
	    txt  = message['list']
	    size = message['size']
	    uid  = message['uid']
	    c = c + 1
	    id = self.create_unique_id()
	    
	    #id = "%s" % c 
	    title = ''

	    self.incoming_folder.manage_addEmail(id,title,size,uid)
	    obj = getattr(self.incoming_folder,id)
	    obj.from_server_list(txt)

	    # apply filter rules :
	    path = self.apply_filter_rules(obj)

	    if path != None :
		# move obj to new path
		ret = self.incoming_folder.manage_cutObjects(obj.id)
		path.manage_pasteObjects(ret)
		# check if sms should be sent
		path.check_send_sms(obj)
	    else :
		# check if sms should be sent
		self.incoming_folder.check_send_sms(obj)
		
	    self.uidl[uid] = 1

	
	if c > 1:
	    message = "downloaded %s new mails (on server: %s)" % (c,number_mails)
	elif c == 1 :
	    message = "downloaded 1 mail (on server: %s)" % number_mails
	else :
	    if number_mails == 1 :
		message = "no new mails on server (%s old mail)" % number_mails
	    else :
		message = "no new mails on server (%s old mails)" % number_mails

	if return_flag == 0 :
	    return
	elif return_flag == 'index' :
	    return self.folder_index_html(self, REQUEST,manage_tabs_message=message)
	elif return_flag == 'sms' :
	    return message
	else :
	    msg = "unknown return_flag %s" + return_flag
	    raise msg

    def create_unique_id(self) :
	" create unique id"

	from DateTime import DateTime 
	return str(DateTime().millis())

    def email_sendAction(self,To='',From='',Subject='',Body='',REQUEST=None) :
	" send an email "
	id     = self.create_unique_id()
	title  = ''
	uid    = None
	size   = 0
	
	self.outgoing_folder.manage_addEmail(id,title,size,uid)
	
	obj = getattr(self.outgoing_folder,id)

	attachment = REQUEST.form['attached_file']
		
	obj.send_mail(From=From, To=To, Subject=Subject,Body=Body, attachment=attachment )
	message = "message successfully sent to %s" % To
	
	return self.folder_index_html(self, REQUEST,manage_tabs_message=message)
	
    def manage_addEmail_Folder(self,id,title):
	" add an email folder"	
	self._setObject(id,email_folder(id,title))


    # Filter rules

    def apply_filter_rules(self, email) :
	" return the path of the folder to move the email into ..."
	
	for rule in self.filter_rules :
	    for field in self.filter_fields :
		if field != rule['field'] : continue 
		if field == 'Body' :
		    searchtext = email.get_body()
		else :
		    exec "str = 'email.%s' % field"
		    exec "searchtext = '%s' % " + str

		res = string.find(searchtext,rule['querytext'])
		if res != -1 :
		    # found !
		    # return changed folder
		    folder = getattr(self,rule['folder'])
		    return folder

	return None
		    
	
    def add_filter_action(self,field,querytext,folder,REQUEST=None) :
	" add a new filter rule "
	title = "%s contains %s move to %s" %(field,querytext,folder)
	rule = {}
	rule['title']  = title
	rule['field']  = field
	rule['folder'] = folder 
	rule['querytext'] = querytext 
	t =(rule,)
	self.filter_rules = self.filter_rules + t
	self._p_changed = 1

	if REQUEST != None :
	    message = "filter rule has been added"	
	    return self.manage_editForm(self, REQUEST,manage_tabs_message=message)
	
    def delete_filter_rule(self,number,REQUEST=None) :
	""" delte a filter rule """
	number = int(number)
	ts =self.filter_rules[:number]
	te =self.filter_rules[number+1:]
	self.filter_rules = ts + te

	if REQUEST != None :
	    message = "filter rule has been deleted"	
	    return self.manage_editForm(self, REQUEST,manage_tabs_message=message)
	
# constructor pages. Only used when the product is added to a folder:

# Get user id from this form :
manage_addEMILForm 	= DTMLFile('dtml/emil_manage_addForm', globals()) 

    
def manage_addEMILAction(self,
			 id='EMIL',
			 title='Title here',
			 server='',
			 username='',
			 password='',
			 get_new='',
			 realname='',
			 reply_to='',			 
			 REQUEST=None):
    "Add a EMIL"
    self._setObject(id, EmailFolder(id, title, server, username, password,get_new,realname,reply_to))
   
    if REQUEST is not None:
	return self.manage_main(self, REQUEST)
    

def addImage(obj,id,file):
    """ from Squishdotadd an image from hard disk"""
    file_path = Globals.package_home(globals())
    f=open(file_path+'/'+file,'r')          
    contents=f.read()     
    f.close()     
    title=id     
    #tlen = len(contents)
    obj.manage_addImage(id,contents,title=title)

    #img_obj = obj.__getitem__(new_id)
    
    #img_obj.content_type = 'image/jpg'  
    img_obj = getattr(obj,id)
    
    #img_obj.manage_upload(contents)
    #return img_obj
        
    
	




