"""
EMIL EMAIL CLIENT
Copyright (C) 2002  Andreas Prlic
andorsch@gmx.at

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

"""


import poplib
import string



class pop_connection :
    "a class to deal with pop connections"
    
    def __init__(self, server, user, password) :
	"initialize connection"
	self.server     = server
	self.user       = user
	self.password   = password
	self.socket     = None	
	
    def open(self) :
	"open connection"
	try:
            self.socket = poplib.POP3(self.server)
        except:
            raise "Connection_Error", "Invalid Server Name >%s<" % self.server

	try:
            self.socket.user(self.user)
        except:
            raise "Connection_Error", "Invalid User Name >%s<" % self.user
	
	try:
            self.socket.pass_(self.password)
        except:
            raise "Connection_Error", "Invalid Password"

    def get_welcome(self) :
	" get the welcome message of the server"
	return self.socket.getwelcome()

    def set_debuglevel(self,level):
	" set the debug level "
	self.socket.set_debuglevel(level)

    def uidl(self,which=None) :
	" return unique id list for the emails"
	if which :
	    return self.socket.uidl(which)
	else :
	    return self.socket.uidl()

    def check(self) :
	" check if connection is still alive, if not, open again"
	try:
	    self.socket.noop()
	    
        except:
	    self.open()

    def status(self):
	" returns the number of messages and the mailboxsize"
	messagecount, mailboxsize = self.socket.stat()

        return messagecount, mailboxsize

    def list(self):
	"return list of message data "
	list = self.socket.list()
	return list
    
    def get_messages(self,get_new=0, known_uidl={}):
	
	" get messages from server and return them as a list of dictionaries "
	# if get_new : only read new emails ( mails which are not known to client )
	self.check()
	number_messages,size = self.socket.stat()

	lst = []
	if number_messages > 0 :
	    c = 1
	    while c <= number_messages :
		#code,id,size = string.split(self.socket.list(c))
		#print code,id,size
		message = {}

		# get message uid
		uidtxt = self.uidl(c)
		
		uid_spl = string.split(uidtxt," ")		
		message['uid']  = uid_spl[2]

		# if uid is knwon to the client,
		# then this message already has been read ...
		if get_new :
		    if known_uidl.has_key(message['uid']) :
			# already known! skip this message!
			c = c + 1
			continue
		
		result,message_lst ,octet = self.socket.retr(c)
		#print "result:>%s< octet>%s<" % ( result,octet)
		message['size'] = octet
		message['list'] = message_lst
	
		lst.append(message)
		c = c + 1
	return lst
    
    def reset(self) :
	" remove any deletion marks from messages "
	self.socket.rset()

    def close(self) :
	"close connection"
	self.socket.quit()
	self.socket = None

    def __del__(self) :
	" if object is destroyed, check and eventually close connection "

	if self.socket != None :
	    self.close()

	


