"""
EMIL EMAIL CLIENT
Copyright (C) 2002  Andreas Prlic
andorsch@gmx.at

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

"""
import Globals
import OFS
from OFS import SimpleItem
from Globals import DTMLFile
from DateTime import DateTime    # to create send_mail time

from  Products.ZCatalog.CatalogAwareness import CatalogAware
import email_message

class SMS_Gateway(CatalogAware, SimpleItem.SimpleItem ) :
    """ a Gateway to send SMS via email """
    
    meta_type = 'SMS_Gateway'
    manage_options = (
	{ 'label': 'Send_SMS',      'action': 'send_sms_html'},	
	{ 'label': 'Properties',    'action': 'manage_editForm'},
	)
    
    __ac_permissions__=(
	('View management screens',['send_sms_html',
				    'manage_editForm',
				    'manage_editAction']),
	)
    
    send_sms_html   = DTMLFile('dtml/sms/send_html',globals())
    manage_editForm = DTMLFile('dtml/sms/manage_editForm_html',globals())
    
    
    def __init__ (self, id, title, \
		  email= '1234567@mobilephone.provider',
		  subject= 'some providers need a pin',
		  sender = 'email_registered@provider'
		  ) :
	""" inits the Folder with default values """
	#self.sms_email   = '1234567@mobilephone.provider'
	#self.sms_subject = 'some providers need a pin'
	#self.sms_sender    = 'email_registered@provider'
	
	self.id = id
	self.title = title
	self.sms_email   = email
	self.sms_subject = subject
	self.sms_sender  = sender
	 
    def manage_editAction(self, title, email,subject,sender,REQUEST=None ) :
	 """ edit gateway properties """
	 self.title = title
	 self.sms_email   = email
	 self.sms_subject = subject
	 self.sms_sender  = sender
	 self._p_changed = 1
	 message = "properties have been changed"
	 return self.manage_editForm(self, REQUEST,manage_tabs_message=message)

    def send_SMSAction(self,mesg,REQUEST=None) :
	""" send an sms to a gateway """
	
	id = self.create_unique_id()	
	self.outgoing_folder.manage_addEmail(id=id,title='SMS',size=0,uid=0)
	msg = getattr(self.outgoing_folder,id)
	msg.send_mail(From=self.sms_sender,To=self.sms_email,
		      Subject=self.sms_subject, Body=mesg)
	
	message = "SMS sent to %s" % self.sms_email
	return self.send_sms_html(self,REQUEST,manage_tabs_message=message)
	 
manage_addForm = DTMLFile('dtml/sms/manage_addForm_html',globals())

def manage_addAction(self,id,title,email,subject,sender,REQUEST=None) :
    """ add an sms_gateway object """
    self._setObject(id,SMS_Gateway(id,title,email,subject,sender))
    
    if REQUEST is not None:
	return self.manage_main(self, REQUEST)
    
	 




