
import OFS
from OFS import SimpleItem
import Globals
from Globals import DTMLFile

class AddressBook(OFS.Folder.Folder) :
    "an AddressBook Folder"

    
    meta_type = 'AddressBook'
    manage_options = ((OFS.ObjectManager.ObjectManager.manage_options[0],)+
		      (	{'label': 'view',   'action': 'index_html',},
			{'label': 'Add_Entry',   'action': 'manage_addAddress',},
			) +
		      AccessControl.Role.RoleManager.manage_options+
		      OFS.SimpleItem.Item.manage_options+
		      OFS.FindSupport.FindSupport.manage_options
		      )
    __ac_permissions__=(
	('View management screens',['manage_editForm','manage_editAction'], ('Owner',)),
	('View',  	           ['index_html',],			    ('Owner',)),     
        )     
    
    index_html         = DTMLFile('dtml/addressbook_index_html'      , globals())

    def __init__(self,id,title) :
	self.id    = id
	self.title = title

addressbook_addForm = DTMLFile('dtml/addressbook_Add',globals())
	
def addressbook_addAddressBook(self,id,title,REQUEST=None) :
    """ add an address book"""

    
    self._setObject(id,AddressBook(title))
    if REQUEST is not None: return self.manage_main(self,REQUEST)

    

class Address(SimpleItem.SimpleItem):
    """ an address entry """

    meta_type = "address"
    
    
    manage_options = (
	{'label': 'View',          'action': 'index_html'},
	{'label': 'Edit',          'action': 'manage_editForm'},
	)

    __ac_permissions__=(
	('View', ['index_html',], ('Owner',)),
	('View management screens',['manage_editForm',], ('Owner',)),
        ) 

    index_html        = DTMLFile('dtml/address_index_html'    , globals())
    manage_editForm   = DTMLFile('dtml/address_editForm_html' , globals())

    def __init__(self,title,firstname,lastname,nickname,email) :
	""" initialize address """

	self.title     = title
	self.firstname = firstname
	self.lastname  = lastname
	self.nickname  = nickname
	self.email     = email

    def address_editAddressAction(self,title,firstname,lastname,nickname,email, REQUEST=None,RESPONSE=None):
	""" edit address"""
	self.title     = title 
	self.firstname = firstname
	self.lastname  = lastname
	self.nickname  = nickname
	self.email     = email
	self._p_changed = 1
	message = "properties have been changed"
	return self.manage_editForm(self, REQUEST,manage_tabs_message=message)
	
	
manage_addAddressForm = DTMLFile('dtml/address_manageAddForm_html',globals())
	
def manage_addAddress(self,id,title,firstname='',lastname='',nickname='',email='',REQUEST=None) :
    """ add an address """
    
    self._setObject(id,Address(title,firstname,lastname,nickname,email))

    if REQUEST is not None: return self.manage_main(self,REQUEST)



