##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################
__doc__='''BTreeFolder Product
$Id: BTreeFolder.py,v 1.2 2000/09/25 20:41:25 shane Exp $'''
__version__='$Revision: 1.2 $'[11:-2]

from AccessControl import getSecurityManager
from OFS.Folder import Folder
from BTree import BTree
from Globals import HTMLFile
from DocumentTemplate.DT_Util import html_quote
from urllib import quote
from cStringIO import StringIO
import Globals

manage_addBTreeFolderForm=HTMLFile('folderAdd', globals())

def manage_addBTreeFolder(self, id, title='',
                          type='full',
                          REQUEST=None):
    """Adds a new BTreeFolder object with id *id*.
    """
    if type == 'full':
        ob = BTreeFolder()
    else:
        ob = BasicBTreeFolder()
    ob.id=str(id)
    ob.title=title
    self._setObject(id, ob)
    ob=self._getOb(id)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)


def _replaceFolder(parent, id, type='basic'):
    # Replaces an OFS.Folder with a BTreeFolder.
    if type == 'full':
        ob = BTreeFolder()
    else:
        ob = BasicBTreeFolder()
    f = parent._getOb(id)
    # Copy the contents of the folder to the new BTree folder.
    ids = f.objectIds()
    for key, value in f.__dict__.items():
        if key not in ids:
            # Not an ObjectManager item.
            ob.__dict__[key] = value
    for key in ids:
        subob = f._getOb(key)
        subob = getattr(subob, 'aq_base', subob)
        ob._setOb(key, subob)
    parent._setOb(id, ob)


listtext0 = '''<select name="ids:list" multiple size="%s">
'''
listtext1 = '''<option>%s</option>
'''
listtext2 = '''</select>
'''

_marker = []  # Create a new marker object.


class BasicBTreeFolder (Folder):
    ' '

    meta_type = 'Basic BTree Folder'
    
    __ac_permissions__=(
        ('View management screens', ('manage_main',
                                     'manage_main_listing',
                                     'manage_object_workspace',)),
    )

    manage_options=(
        ({'label':'Contents', 'action':'manage_main',},
         ) + Folder.manage_options[1:]
        )

    manage_main = HTMLFile('contents', globals())
    
    def __init__(self):
        self._tree = BTree()

    def _getOb(self, id, default=_marker):
        tree = self._tree
        if not tree.has_key(id):
            if default is _marker:
                raise AttributeError, id
            return default
        else:
            return tree[id].__of__(self)

    def _setOb(self, id, object):
        # Saves the object in the BTree instead of the dictionary.
        tree = self._tree
        tree[id] = object
        # May add logic here to make BTreeFolder work as expected with
        # transparent folders.

    def _delOb(self, id):
        # May add logic here to make BTreeFolder work as expected with
        # transparent folders.
        tree = self._tree
        del tree[id]

    def manage_main_listing(self, REQUEST):
        '''Generates a select box.'''
        if REQUEST.has_key('dtpref_rows'):
            pref_rows = REQUEST['dtpref_rows']
        else:
            pref_rows = 20
        rval = StringIO()
        rval.write(listtext0 % pref_rows)
        counter = 0
        idlist = self.objectIds()
        idlist.sort()
        for id in idlist:
            html_fmt = html_quote(id)
            rval.write(listtext1 % html_fmt)
            counter = counter + 1
        rval.write(listtext2)
        return rval.getvalue()

    def manage_object_workspace(self, REQUEST):
        '''Redirects to the workspace of the first object in
        the list.'''
        ids = REQUEST.get('ids', [])
        if len(ids) > 0:
            REQUEST.RESPONSE.redirect(
                '%s/%s/manage_workspace' % (
                self.absolute_url(), quote(ids[0])))
        else:
            return self.manage_main(self, REQUEST)

Globals.default__class_init__(BasicBTreeFolder)


class BTreeFolder (BasicBTreeFolder):
    ' '

    meta_type = 'BTree Folder'
    
    def __getattr__(self, name):
        # Finds the attribute in the BTree instead of the dictionary.
        tree = self._tree
        if tree.has_key(name):
            ob = tree[name]
            return ob
        else:
            return higher_getattr(self, name)

try:
    higher_getattr = BTreeFolder.inheritedAttribute('__getattr__')
except:
    def higher_getattr(self, name):
        raise AttributeError, name


Globals.default__class_init__(BTreeFolder)
