
import Globals
from Globals import Persistent, Acquisition
import AccessControl
import OFS


class Poll (
    Acquisition.Implicit,
    Persistent,
    AccessControl.Role.RoleManager,
    OFS.SimpleItem.Item,
    ):
    "A multiple choice poll."

    __ac_permissions__=(
        ('View management screens', ('manage_main',)),
        ('View', ('', 'index_html', 'getQuestion', 'getChoices')),
        ('Change Polls', ('manage_edit',), ('Manager',)),
        ('Vote', ('vote_form', 'castVote',), ('Anonymous', 'Manager')),
        ('View voting statistics',
         ('vote_results', 'getTotalVotes', 'getVotesFor'),
         ('Anonymous', 'Manager')),
        )

    manage_options=(
        {'label':'Properties', 'action':'manage_main'},
        {'label':'View', 'action':''},
        ) + OFS.SimpleItem.SimpleItem.manage_options

    meta_type = 'Poll'

    index_html = Globals.HTMLFile("poll", globals())
    manage_main = Globals.HTMLFile("edit_poll", globals())
    vote_form = Globals.HTMLFile("vote_form", globals())
    vote_results = Globals.HTMLFile("vote_results", globals())

    def __init__(self, id, title, question, choices):
        self.id = id
        self.title = title
        self._question = question
        self._choices = tuple(choices)
        self._votes = Globals.PersistentMapping()
        for choice in choices:
            self._votes[choice] = 0

    def castVote(self, choice):
        "Votes for a choice"
        vote_count = self.getVotesFor(choice)
        self._votes[choice] = vote_count + 1

    def getTotalVotes(self):
        "Returns total number of votes cast"
        total = 0
        choices = self._choices
        for choice, v in self._votes.items():
            if choice in choices:
                total = total + v
        return total

    def getVotesFor(self, choice):
        "Returns number of votes cast for a given choice"
        if choice in self._choices:
            if self._votes.has_key(choice):
                vote_count = self._votes[choice]
            else:
                vote_count = 0
            return vote_count
        else:
            message = ('%s is not one of the available choices.'
                       % choice)
            raise ValueError, message

    def getChoices(self):
        "Returns the list of choices"
        return self._choices

    def getQuestion(self):
        "Returns the question"
        return self._question

    def manage_edit(self, title, question, choices, REQUEST=None):
        "Edits the poll's characteristics"
        self.title = title
        self._question = question
        new_choices = []
        for choice in choices:
            if choice:
                new_choices.append(choice)
        if len(new_choices) < 2:
            raise ValueError, ('You must supply at least two valid'
                               'choices.')
        self._choices = tuple(new_choices)
        if REQUEST is not None:
            return Globals.MessageDialog(
                title='Edited',
                message='<strong>%s</strong> has been edited.' % self.id,
                action ='manage_main',
                )

Globals.default__class_init__(Poll)


def manage_addPoll(self, id, title, question, choices, REQUEST=None):
    """Create a poll and install it in its parent Folder.
    The argument 'self' will be bound to the parent Folder.
    """
    poll = Poll(id, title, question, choices)
    self._setObject(id, poll)
    if REQUEST is not None:
        return self.manage_main(self, REQUEST)

manage_addPollForm = Globals.HTMLFile('add_poll', globals())
