
# The line below helps Python locate DocumentTemplate.
import sys, os; sys.path.append(os.path.join('..', '..'))

import DocumentTemplate

class Poll:
    "A multiple choice poll."

    index_html = DocumentTemplate.HTMLFile("poll2.dtml")

    def __init__(self, question, choices):
        self.question = question
        self.choices = choices
        self.votes = {}
        for choice in choices:
            self.votes[choice] = 0

    def castVote(self, choice):
        "Votes for a choice"
        if choice in self.choices:
            self.votes[choice] = self.votes[choice] + 1
        else:
            message = ('%s is not one of the available choices.'
                       % choice)
            raise ValueError, message

    def getTotalVotes(self):
        "Returns total number of votes cast"
        total = 0
        for v in self.votes.values():
            total = total + v
        return total

    def getVotesFor(self, choice):
        "Returns number of votes cast for a given choice"
        return self.votes[choice]

    def getChoices(self):
        "Returns the list of choices"
        return tuple(self.choices)

    def getQuestion(self):
        "Returns the question"
        return self.question

