
from DocumentTemplate import DT_In, DT_Let, DT_Raise, DT_String, DT_Try
from DocumentTemplate import DT_Util, DT_With
from DocumentTemplate.DT_Util import TemplateDict
from DocumentTemplate.DT_Return import DTReturn
import sys
from Globals import HTMLFile
from DocumentTemplate.DT_Util import InstanceDict, careful_getattr
from ZPublisher.BaseRequest import BaseRequest
from string import join, find

# Zope 2.2 dependency--needed in order to get innermost DTML method.
try: from AccessControl import getSecurityManager
except: pass

dtmlexc = HTMLFile('dtmlexc', globals())

MappingType = type({})

SHOW_SOURCE_CODE = 1

class DebugInstanceDict(InstanceDict):
    # An InstanceDict that lets us get at the underlying object.
    #__allow_access_to_unprotected_subobjects__ = 1
    def __init__(self, ob, namespace, validate=None):
        self._ob = ob
        if validate is not None:
            InstanceDict.__init__(self, ob, namespace, validate)
        else:
            InstanceDict.__init__(self, ob, namespace)

    def _getInstanceDictOb(self):
        return self._ob


def debugGetKey(entry, name, namespace):
    # Gets a value from entry, throwing the appropriate exception
    # if there is a validation error.
    try:
        ob = entry._getInstanceDictOb()
        val = getattr(ob, name)
    except:
        val = entry[name]
    else:
        if hasattr(namespace, 'validate'):
            namespace.validate(
                ob, ob, name, val, namespace)
        val = careful_getattr(namespace, ob, name)
    return val

def explodeNamespaceStack(stack, name, namespace):
    # If name is not None, tries to look it up in each entry of the namespace.
    lookup_stack = []
    for entry in stack:
        info = {}
        t = type(entry)
        try:
            info['id'] = entry['id']
        except:
            info['id'] = '?'
        if t is MappingType:
            info['id'] = '(N/A)'
            if len(entry) <= 3:
                info['type'] = 'mapping with keys: %s' % entry.keys()
            else:
                info['type'] = 'mapping with %d keys' % len(entry)
        elif t is DebugInstanceDict:
            info['type'] = 'InstanceDict'
        elif isinstance(entry, BaseRequest):
            info['id'] = 'REQUEST'
            info['type'] = str(entry.__class__)
        elif hasattr(entry, '__class__'):
            info['type'] = str(entry.__class__)
        else:
            info['type'] = str(t)
        if name is not None:
            try:
                val = debugGetKey(entry, name, namespace)
            except (KeyError, AttributeError):
                info['contains'] = 'No'
            except:
                exc = sys.exc_info()[:2]
                info['contains'] = '%s: %s' % exc
            else:
                info['contains'] = 'Value: %s' % str(val)[:32]
        lookup_stack.append(info)
    return lookup_stack

def getCurrentDTMLMethod():
    # Finds the innermost DTML method from the security context stack.
    try:
        security = getSecurityManager()
        exec_stack = security._context.stack
        index = len(exec_stack) - 1
        while index >= 0:
            method = exec_stack[index]
            if hasattr(method, '_v_blocks'):
                return method
            index = index - 1
    except:
        return None

def explodeCallStack():
    # Lists and returns all DTML and TTW Python method calls in the
    # security context stack.
    try:
        security = getSecurityManager()
        exec_stack = security._context.stack
        rval = []
        for method in exec_stack:
            try:
                info = join(method.getPhysicalPath(), '/')
            except:
                info = str(method)
            rval.append(info)
        rval.reverse()
        return rval
    except:
        return None

def getSourceInfo(method, section):
    # Returns the source code of the method split into three parts.
    # The middle part is the part where the exception occurred.
    # If anything goes wrong, returns None.
    if SHOW_SOURCE_CODE:
        found = 0
        if hasattr(method, '_v_debuginfo'):
            debuginfo = method._v_debuginfo
            for method_section, start, end in debuginfo:
                if method_section is section:
                    found = 1
                    break
        if found:
            raw = method.read()
            return raw[:start], raw[start:end], raw[end:]
    return None

def debugWithNamespace(section, namespace, name=None, exc_info=None):
    # Collects info about the exception that just occurred and re-throws
    # the exception with detailed HTML.
    try:
        stack = []
        # Unstack then rebuild the namespace.
        try:
            while len(namespace) > 0:
                stack.append(namespace._pop())
            stack.reverse()
            for entry in stack:
                namespace._push(entry)
        except:
            namespace = None
        # Output info from the stack.
        stack.reverse()
        lookup_stack = explodeNamespaceStack(stack, name, namespace)
        # Get the innermost DTML method.
        method = getCurrentDTMLMethod()
        if method is not None:
            method_name = join(method.getPhysicalPath(), '/')
            source_info = getSourceInfo(method, section)
            method_url = method.absolute_url()
            call_stack = explodeCallStack()
        else:
            method_name = None
            source_info = None
            method_url = None
            call_stack = None
        # Output the collected information.
        if exc_info is not None:
            raise exc_info[0], dtmlexc(None, None, lookup_name=name,
                                       lookup_stack=lookup_stack,
                                       method_url=method_url,
                                       method_name=method_name,
                                       source_info=source_info,
                                       call_stack=call_stack,
                                       exc_type=str(exc_info[0]),
                                       exc_value=str(exc_info[1]),
                                       exc_tb=exc_info[2]), exc_info[2]
        else:
            return dtmlexc(None, None, lookup_name=name,
                           lookup_stack=lookup_stack,
                           method_url=method_url,
                           method_name=method_name,
                           source_info=source_info,
                           call_stack=call_stack)
    finally:
        if exc_info is not None:
            # Paranoia.
            del exc_info

def debugException(section, namespace):
    # Analyzes the exception that just occurred and either delegates to
    # debugWithNamespace() or re-throws the exception.
    info = sys.exc_info()
    try:
        if find(str(info[1]), '<html>') >= 0:
            # Don't try to change HTML.
            raise
        exc_type = info[0]
        if exc_type in (KeyError, NameError):
            # Namespace lookup problem?
            name = None
            if type(namespace) is TemplateDict:
                try:
                    name = str(info[1])
                    val = namespace.getitem(name, 0)
                except KeyError, k:
                    if name != str(k):
                        name = None
                    # else it is indeed a namespace lookup problem.
                else:
                    # It is not a namespace lookup problem.
                    name = None
            debugWithNamespace(section, namespace, name, info)
        elif str(exc_type) == 'Redirect':
            # Just continue redirecting.
            raise
        elif exc_type is DTReturn:
            # Return normally.
            raise
        else:
            debugWithNamespace(section, namespace, None, info)
    finally:
        # Fixes circular reference?
        del info

def debug_render_blocks(blocks, md, TupleType=type(()), StringType=type('')):
    # Modified from pDocumentTemplate. Calls debugException() when
    # an exception occurs.  These mods could be folded back in to
    # cDocumentTemplate to get DTML debugging without a performance penalty.
    rendered = []
    append=rendered.append
    for section in blocks:
        if type(section) is TupleType:
            l=len(section)
            if l==1:
                # Simple var
                data=section[0]
                try:
                    if type(data) is StringType: data=md[data]
                    else: data=data(md)
                except:
                    debugException(section, md)
                section=str(data)
            else:
                # if
                cache={}
                md._push(cache)
                try:
                    i=0
                    m=l-1
                    while i < m:
                        cond=section[i]
                        if type(cond) is StringType:
                            # Name lookup condition.
                            n=cond
                            try:
                                cond=md[cond]
                                cache[n]=cond
                            except KeyError, v:
                                v=str(v)
                                if n != v:
                                    debugException(section, md)
                                    # raise KeyError, v, sys.exc_traceback
                                cond=None
                        else:
                            # Expr condition.
                            try:
                                cond=cond(md)
                            except:
                                debugException(section, md)
                        if cond:
                            section=section[i+1]
                            if section: section=debug_render_blocks(section,md)
                            else: section=''
                            m=0
                            break
                        i=i+2
                    if m:
                        if i==m: section=debug_render_blocks(section[i],md)
                        else: section=''

                finally: md._pop()

        elif type(section) is not StringType:
            try:
                section=section(md)
            except:
                debugException(section, md)

        if section: rendered.append(section)

    l=len(rendered)
    if l==0: return ''
    elif l==1: return rendered[0]
    return join(rendered, '')
    return rendered


# Apply patches.
for m in (DT_Util, DT_In, DT_Let, DT_Raise, DT_String, DT_Try, DT_With):
    m.render_blocks = debug_render_blocks
    m.InstanceDict = DebugInstanceDict
