
from DocumentTemplate.DT_String import String
from DocumentTemplate.DT_Util import ParseError
from DocumentTemplate.DT_Var import Var

if 1:
    # Patch DT_String to store _v_debuginfo, which is a list of tuples
    # containing the section, the start position, and the end position
    # of each DTML tag in the source DTML.  DTMLDebug.getSourceInfo()
    # uses this information.

    def parse(self,text,start=0,result=None,tagre=None):
        if result is None: result=[]
        if tagre is None: tagre=self.tagre()
        l=tagre.search(text,start)
        while l >= 0:

            try: tag, args, command, coname = self._parseTag(tagre)
            except ParseError, m: self.parse_error(m[0],m[1],text,l)

            s=text[start:l]
            if s: result.append(s)
            start=l+len(tag)

            if hasattr(command,'blockContinuations'):
                start=self.parse_block(text, start, result, tagre,
                                       tag, l, args, command)
            else:
                try:
                    if command is Var: r=command(args, self.varExtra(tagre))
                    else: r=command(args)
                    if hasattr(r,'simple_form'): r=r.simple_form
                    if hasattr(self, '_v_debuginfo'):
                        self._v_debuginfo.append((r, l, l+len(tag)))
                    result.append(r)
                except ParseError, m: self.parse_error(m[0],tag,text,l)

            l=tagre.search(text,start)

        text=text[start:]
        if text: result.append(text)
        return result


    def parse_block(self, text, start, result, tagre,
                    stag, sloc, sargs, scommand):

        start=self.skip_eol(text,start)

        blocks=[]
        tname=scommand.name
        sname=stag
        sstart=start
        sa=sargs
        while 1:

            l=tagre.search(text,start)
            if l < 0: self.parse_error('No closing tag', stag, text, sloc)

            try: tag, args, command, coname= self._parseTag(tagre,scommand,sa)
            except ParseError, m: self.parse_error(m[0],m[1], text, l)

            if command:
                start=l+len(tag)
                if hasattr(command, 'blockContinuations'):
                    # New open tag.  Need to find closing tag.
                    start=self.parse_close(text, start, tagre, tag, l,
                                           command, args)
            else:
                # Either a continuation tag or an end tag
                section=self.SubTemplate(sname)
                section._v_blocks=section.blocks=self.parse(text[:l],sstart)
                section._v_cooked=None
                blocks.append((tname,sargs,section))

                start=self.skip_eol(text,l+len(tag))

                if coname:
                    tname=coname
                    sname=tag
                    sargs=args
                    sstart=start
                else:
                    try:
                        r=scommand(blocks)
                        if hasattr(r,'simple_form'): r=r.simple_form
                        if hasattr(self, '_v_debuginfo'):
                            self._v_debuginfo.append((r, sloc, sloc+len(stag)))
                        result.append(r)
                    except ParseError, m: self.parse_error(m[0],stag,text,l)

                    return start

    def cook(self):
        # Sets up _v_debuginfo just before parsing the DTML.
        self._v_debuginfo=[]
        self._DT_String_cook()

    def __call__(self,client=None,mapping={},**kw):
        '''Re-parses the DTML if _v_debuginfo is not present.'''
        if not hasattr(self, '_v_debuginfo'):
            self.cook()
        return apply(self._DT_String__call__, (client, mapping), kw)

    # Apply the patches.
    String._DT_String_cook = String.cook
    String._DT_String__call__ = String.__call__
    String.parse = parse
    String.parse_block = parse_block
    String.cook = cook
    String.__call__ = __call__
