import os
import string
import types
import shutil
from   os import path
from   os.path import join


lowerlist = list(string.lowercase)


class QueueDirectory:
    
    def __init__(self, root):
        self.root = root
        
    def add_fileobj(self, fileobj):
        shutil.copyfile(fileobj, path.join(
                                           self.root,  
                                           path.basename(fileobj.name) 
                                           ) 
                        )
        
    def get_file(file):
        return open(join(self.root, file))

class BucketDirectory:
    
    def __init__(self, root):
        self.root = root
    
    def add_fileobj (self, fileobj):
        name = path.basename(fileobj.name)
        c = find_char(name)
        shutil.copyfileobj(fileobj, path.join(self.root, c, name))

    def add_file (self, file):
        name = path.basename(file)
        c = find_char(name)
        shutil.copyfile( file, path.join(self.root, c, name) )

    def get_file (self, file):
        c = find_char(name)
        fpath = path.join(self.root,c,name) 
        
        if path.exists( fpath ):
            return open(fpath)

    def list_files(self):
        # lists w/ abs path
        files = []
        path.walk(self.root,file_collector,files)
        return files
        
    def create(self, d):
        make_letter_buckets(d)

        
def file_collector( all , d, files):
    all.extend([join(d, f) for f in files if not path.isdir(f)])

def find_char(s):
    
    if type(s) is not types.StringType:
        raise SyntaxErrox (" invalid args to find chars")

    s = s.lower()
    
    for c in s:
        if c in lowerlist:
            return c
    
    raise SyntaxError ( " invalid args to find chars ")
        
def move_file(f, d):
    " move a file "
    name = path.basename(f.name)
    shutil.copyfileobj(f,path.join(d, name))

def make_letter_buckets(d):
    curdir = os.getcwd()
    os.chdir(d)
    
    for c in string.lowercase:
        os.mkdir(c)
        
    os.chdir(curdir)
    
if __name__ == '__main__':
    try:
        make_letter_buckets('/opt/catalog/packages')
    except: pass
        
    print 'done'
