import gzip
import tarfile

_register= {}

def register_extension(type, factory):
    _register[type]=factory

def get_file_formats():
    return _register.keys()

class _GzipFactory:
    pass

GzipFactory = _GzipFactory()

class _TgzFactory:
    pass

TgzFactory = _TgzFactory()

register_extension( 'zip', GzipFactory)
register_extension( 'tar.gz', TgzFactory)
register_extension( 'tgz', TgzFactory)

