"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

"""
Gideon/Log/Log.py

  Provides an abstraction to the underlying logging
  framework.

Author: Kapil Thangavelu
License: GPL
CVS: $Id: Log.py,v 1.1.1.1 2001/12/31 04:07:06 ender Exp $
"""

from zLOG import register_subsystem, LOG

APP_NAME = '[Repository]'

class DasLogger:

    def __init__(self, name):
        self._sysname = name
        register_subsystem(name)
    def debug(self, msg, extra=''):
        LOG(self._sysname, 0, msg, extra)
    def warning(self, msg):
        zLOG.LOG(self._sysname, 100, msg, extra)    
    def error(self, msg):
        zLOG.LOG(self._sysname, 200, msg, extra)        
    def panic(self, msg):
        zLOG.LOG(self._sysname, 300, msg, extra)

log = DasLogger(APP_NAME)

del DasLogger

class ComponentLogging:

    def __init__(self, app_name, component_name):
        self._app = app_name
        self._component = component_name

    def debug(self, msg, extra=''):
        
        LOG(self._app ,
            0,
            "[%s] : %s  "%(self._component, msg),
            extra)
        
    def warning(self, msg, extra=''):
        
        LOG(self._app ,
            100,
            "[%s] : %s  "%(self._component, msg),
            extra)
    def error(self, msg, extra=''):
        
        LOG(self._app ,
            200,
            "[%s] : %s  "%(self._component, msg),
            extra)
    def panic(self, msg, extra=''):
        
        LOG(self._app ,
            300,
            "[%s] : %s  "%(self._component, msg),
            extra)

def LogFactory(component_name):

    return ComponentLogging(APP_NAME, component_name)
    


