"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from xml.sax import make_parser

from MetadataHandler import MetadataHandler

class CiphonXmlError(Exception): pass

class CiphonHandler(MetadataHandler):
   
   def initHandler(self):
      self._package_list = []      
      self._package = {}      

   def endPackage(self):
      self._package_list.append(self._package)
      self._package = {}

   ## simple types
   def endName(self):
      self._package['name']= self._strstripbuffer
     
   def endVersion(self):
      self._package['version'] = self._strstripbuffer
   
   def endLicense(self):
      self._package['license'] = self._strstripbuffer
      
   def endUrl(self):
      self._package['url'] = self._strstripbuffer
      
   def endPath(self):
      self._package['path'] = self._strstripbuffer 
      
   def endSize(self):
      self._package['size'] = self._strstripbuffer 

   def endDescription(self):
      self._package['description'] = self._strstripbuffer 
      
   ## complex types
   
   # authors
   def startAuthor(self, attrs):
      authors = self._package.get('authors', [])
      authors.append( {'name':str(attrs.get('name')), 'email':str(attrs.get('email'))} )
      self._package['authors']=authors

   # the rest is dependency support
   def startDependencies(self, attrs):
      self._package['dependencies']=[]

   def startDependeny(self, attrs):
      self._dependency = {}
      self.setMethodPrefix('Dependency')

   def endDependency(self):
      self._package.get('dependencies').append(self._dependency)
      self._dependency=None
      self.setMethodPrefix('')
      
   def endDependencyName(self):
      self._dependency['name']= self._strstripbuffer 

   def startDependencyVersion(self, attrs):
      self._dependency['dependency_type']= str(attrs.get('type'))
      
   def endDependencyVersion(self):
      self._dependency['version'] = self._strstripbuffer 
      
   def get_package_info(self): 
      return self._package_list
   
if __name__ == '__main__':
   import sys
   import pprint
   p = make_parser()
   ch = CiphonHandler()
   p.setContentHandler(ch)
   p.parse(sys.argv[1])
   pprint.pprint(ch.get_package_info().pop())
