"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from xml.sax import ContentHandler

class XmlMetadataHandlingError(Exception): pass

class MetadataHandler(ContentHandler):
   
   def __init__(self): 
      self._buffer = []
      self._strstripbuffer = ''
      self._prefix = ''
      ContentHandler.__init__(self)
      
      self.initHandler()
      
   def setMethodPrefix(self, prefix):
      self._prefix = prefix
      
   def startElement(self, name, attrs): 
      name = name.lower()
      if self._prefix: name = '%s%s'%(self._prefix, name.capitalize())      
      method = getattr(self, 'start%s'%name.capitalize(), None)
      
      if method: 
         try: apply(method, (attrs,))
         except Exception, e: 
            raise XmlMetadataHandlingError("error in %s :"%name+str(e))
   
   def endElement(self, name): 
      name = name.lower()

      if self._prefix: name = '%s%s'%(self._prefix, name.capitalize())            
      method = getattr(self, 'end%s'%name.capitalize(), None)

      self._strstripbuffer = str(''.join(self._buffer)).strip()
      
      if method: 
         try: apply(method, ())
         except Exception, e: 
            raise XmlMetadataHandlingError("error in %s :"%name+str(e))         
         
      self._buffer = []
      self._strstripbuffer = ''
      
   def characters(self, content): 
      self._buffer.append(content)
      
      
