"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from xml.sax import make_parser
from MetadataHandler import MetadataHandler

class PPDHandler(MetadataHandler):
    
    def initHandler(self):
        self._software = {}
        self._implementations = []

    def startSoftpkg(self, attrs):
        self._software['name'] = str(attrs['NAME'])
        self._software['version'] = str(attrs['VERSION']).replace(',','.')
        
    def endSoftpkg(self):
        self._software['implementations']=self._implementations
        
    def endTitle(self):
        self._software['title'] = str(''.join(self._buffer).strip())
        
    def endAbstract(self):
        self._software['summary'] = str(''.join(self._buffer).strip())
        
    def endAuthor(self):
        self._software['author'] = str(''.join(self._buffer).strip())
       
        
    # the rest is for implementation info
    
    def startImplementation(self, attrs):
        self._implementation = {}
        
    def endImplementation(self):
        self._implementations.append(self._implementation)

    def startPythoncore(self, attrs):
        self._implementation['python_version'] = str(attrs['VERSION'])
        
    def startOs(self, attrs):
        self._implementation['os'] = str(attrs['VALUE'])

    def startArchitecture(self, attrs):
        self._implementation['arch'] = str(attrs['VALUE'])
        
    def startCodebase(self, attrs):
        self._implementation['codebase'] = str(attrs['HREF'])
        
    def get_package_info(self):
        return self._software
                           
        
if __name__ == '__main__':
   import sys
   import pprint
   p = make_parser()
   ch = PPDHandler()
   p.setContentHandler(ch)
   p.parse(sys.argv[1])
   pprint.pprint(ch.get_package_info())    
