"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

import unittest 

import Pep241Parser
import PPDParser

_files = {
          '4suite':'data/4Suite-PKG-INFO',
          'Webservice':'data/Webservice-PKG-INFO',
          'dumper':'data/dumper_ppd.xml'
          }

class Pep241ParserTests(unittest.TestCase):
    
    def testParser4Suite(self):
        """ testing PEP241 parser against 4suite PKG-INFO """

        info = Pep241Parser.parse_file(_files['4suite'])
        
        assert info['metadata-version'] == '1.0'
        assert info['version'] == '0.11.1b2'
        assert info['author'] == 'Fourthought, Inc.'
        assert info['author-email'] == 'support@4suite.org'
        assert info['license'] == 'UNKNOWN'
        assert info['platform'] == 'UNKNOWN'
        

    def testParserWebservice(self):
        """ testing PEP241 parser against Webservice PKG-INFO """
        
        info = Pep241Parser.parse_file(_files['Webservice'])

        assert info['name'] == 'WebService'
        assert info['metadata-version'] == '1.0'
        assert info['version'] =='1.0a'
        assert info['home-page'] == 'UNKNOWN'
        assert info['author'] == 'Brian Lloyd'
        assert info['author-email'] == 'brian@zope.com'
        assert info['license'] == 'UNKNOWN'
        assert info['description'] == 'UNKNOWN'
        assert info['platform'] == 'UNKNOWN'
        
        
def make_pep241_parser_suite():
    return unittest.makeSuite(Pep241ParserTests, "test")

class PPDParserTests(unittest.TestCase):

    def testParserDumper(self):
        """ testing PPD parser against Dumper PPD xml"""

        info = PPDParser.parse_file(_files['dumper'])
        
        assert info['version'] == "1,0"
        assert info['name'] == 'dumper'
        assert info['summary'] == 'Dump nested Python data structures.'
        
def make_ppd_parser_suite():
    return unittest.makeSuite(PPDParserTests, "test")
                   
def make_all_parser_suite():
    return unittest.TestSuite((make_ppd_parser_suite(), make_pep241_parser_suite()))
   

    
if __name__ == '__main__':
    print 'running parser unit tests'
    runner = unittest.TextTestRunner()
    runner.run(make_all_parser_suite())
