"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Gideon.Objects.Namespace import *
from IApplicationManager import IApplicationManager

_marker=[]

class ApplicationManager:

    __implements__ = (IApplicationManager,)

    def __init__(self):
        
        self._application_registry = PersistentMapping()

    def register_application(self, name, object):
        
        self._application_registry[name]=object.getPhysicalPath()

    def get_application_for_name(self, name, default=_marker):
        
        application = self._application_registry.get(name, default)
        
        # only one 1 app manager per system

        if application:
            return self.unrestrictedTraverse('/'.join(application))

        elif application is _marker:
            # try to go up the context
            
            app = self.get_inner_application(self)
            next = self.get_inner_application(self, 2)
            
            if app is next:
                raise ApplicationLookupError("%s application not found"%name)

            next.get_application(name)
        else:
            return application
            
