"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $



import os
from UserDict import UserDict

from Globals import ImageFile

from Products.Gideon.Objects.Namespace import *

from Products.Gideon.Objects.EventChannel import EventChannel
from Products.Gideon.Objects import Packages
from Products.Gideon.Objects.Authors.Authors import \
     AuthorContainer, AuthorBrowser
from Products.Gideon.Objects.Categories.Categories import CategoryContainer
from Products.Gideon.Objects.NewsSink import NewsSink
from Products.Gideon.Objects.UserDirectory import BTreeUser, UserDirectory
from Products.Gideon.Objects.CookieMonster.CookieCrumbler import CookieCrumbler
from Products.Gideon.Objects.Ratings.RatingService import RatingService

RATING_ID = 'RatingService'
EC_ID = 'EventChannel'
AUTHOR_ID = 'Authors'
IMAGE_ID = 'Images'
PACKAGE_ID = 'Packages'
PACKAGE_UP_ID = 'PackageUpload'
CATEGORY_ID = 'Categories'
CAT_ID = 'SiteCatalog'
COOKIE_MONSTER = 'CookieMonster'
MAIL_ID = 'MailServer'
MAIL_HOST = 'localhost'
MAIL_PORT = 25
NEWSID = 'NewsSink'
USERDIRECTORY = 'Members'

def install_ui(self):
    from Products.Gideon import gideon_home    
    ob = Folder(IMAGE_ID, IMAGE_ID)
    ob.id = IMAGE_ID
    ob.title = IMAGE_ID
    self._setObject(IMAGE_ID, ob)
    ob = getattr(self, IMAGE_ID)
    
    f = open(os.path.join(gideon_home, 'images/python_repository.png'))
    ob.manage_addProduct['OFSP'].manage_addImage(os.path.basename(f.name), f)
    
    ##ob.python_repository_image = ImageFile('images/python_repository.png', gideon_home)

def install_event_channel(self):
    ob = EventChannel.EventChannel(EC_ID, EC_ID)
    self._setObject(EC_ID,ob)
    # install the various channels
    ob = getattr(self, EC_ID)

    ob.register_event_type('member created')
    ob.register_event_type('package added to queue')
    ob.register_event_type('package removed from queue')    
    ob.register_event_type('package published')
    ob.register_event_type('package version created')
    ob.register_event_type('package categories modified')
    ob.register_event_type('package modified') ##??
    ob.register_event_type('recatalog object')      
    ob.register_event_type('catalogable object created')
    ob.register_event_type('subscription created')
    ob.register_event_type('invalidate cache')

def install_rating_service(self):
    ob = RatingService(RATING_ID)
    self._setObject(RATING_ID, ob)
    

def install_site_catalog(self): 

    from Products.Gideon.Objects.Catalog.CatalogSchema import get_default_schema
    from Products.ZCatalog import ZCatalog
    
    ob = ZCatalog(CAT_ID, CAT_ID)
    cat = getattr(self, id)
    schema =  get_default_schema()
    
    getidx = schema.indexes.get
    for idx in schema.indexes.keys():
        cat.addIndex(idx, getidx(idx))

    for col in schema.columns:
        cat.addColumn(col)    
    

def install_mail_server(self, config=None): 

    from Products.Gideon.Objects.BulkTxnMailer.BulkTxnMailer \
         import BulkTransactionalMailer

    info = {
            'id':MAIL_ID,
            'host': MAIL_HOST,
            'port':MAIL_PORT
            }

    id   = info.get('id')
    host = info.get('host')
    port = info.get('port', 25)	
    
    ob = BulkTransactionalMailer(id, host, port)

    self._setObject(id, ob)

def _make_letter_containers(ob, factory):
    import string
    for c in string.lowercase:
        container = factory(c, c)
        container.id = c
        container.title = c
        ob._setObject(c, container)
    
    
def _make_letter_folders(ob):
    import string
    for c in string.lowercase:
        ob.manage_addProduct['OFSP'].manage_addFolder(c, c)
    
def install_authors(self):    
    
    ob = AuthorContainer(AUTHOR_ID,AUTHOR_ID)
    ob.id = AUTHOR_ID
    ob.title = AUTHOR_ID
    self._setObject(AUTHOR_ID, ob)
    
    ob = self._getOb(AUTHOR_ID)
    
    _make_letter_folders(ob)
    
def install_categories(self):
    
    ob = CategoryContainer(CATEGORY_ID,CATEGORY_ID)
    ob.id = CATEGORY_ID
    ob.title = CATEGORY_ID
    self._setObject(CATEGORY_ID, ob)
    
    ob = getattr(self, CATEGORY_ID)
    from Products.Gideon import gideon_home    
    try:
        from xml.sax import make_parser
        from Products.Gideon.Objects.Categories.CategoryLoader import CategoryHandler
        h = CategoryHandler(ob)
        p = make_parser()
        p.setContentHandler(h)
        p.parse(os.path.join(gideon_home, 'config', 'category.xml'))
    except:
	import traceback; traceback.print_exc()

def install_cookie_monster(self):
    ob = CookieCrumbler(COOKIE_MONSTER)
    ob.id = COOKIE_MONSTER
    ob.title = COOKIE_MONSTER
    self._setObject(COOKIE_MONSTER, ob)
        
def install_users_directory(self):
    ob = UserDirectory.UserDirectory(USERDIRECTORY,USERDIRECTORY)
    self._setObject(USERDIRECTORY,ob)
    
def install_users_folder(self):
    ob = BTreeUser.BTreeUserFolder()
    self = self.this()
    self._setObject('acl_users', ob)
    self.__allow_groups__ = ob

                         
class FakeRequest(UserDict): pass
    
def install_users_xuf(self, config=None):
    ## lets try it with exUserFolder

    LOGINFORM = 'LoginForm'
    curdir = package_home(globals())

    lf = os.path.join(curdir, 'dtml/MemberLoginForm.dtml')
    
    
    self.manage_addProduct['OFSP'].manage_addDTMLMethod(LOGINFORM,
                                                        LOGINFORM, 
                                                        open(lf)
                                                        )
    from PythonRepository import PythonRepository    
    #PythonRepository.LoginForm = DTMLFile('dtml/MemberLoginForm', globals())
    PythonRepository.ChangePasswordForm = DTMLFile('dtml/MemberChangePasswordForm', globals())
    PythonRepository.SignupForm = DTMLFile('dtml/MemberSignupForm', globals())
    PythonRepository.ForgotMyPassword = DTMLFile('dtml/MemberForgotPasswordForm', globals())
    
    from Products.exUserFolder.exUserFolder import manage_addexUserFolder, exUserFolder
    
    REQUEST = FakeRequest()
    REQUEST['basicmember_mailhost']=MAIL_ID
    REQUEST['basicmember_forgottenpasswords']='hint'
    REQUEST['basicmember_changepasswords']=1
    REQUEST['basicmember_postlogin']='destination'
    #REQUEST['basicmember_pvfeatures']=[]
    REQUEST['basicmember_passwordpolicy']='user'
    REQUEST['basicmember_createhomedir']=1
    REQUEST['basicmember_homeroot']='Members'
    REQUEST['basicmember_baseurl']='/'.join(self.getPhysicalPath())
    REQUEST['basicmember_loginpage']='LoginForm'
    REQUEST['basicmember_signuppage']='SignupForm'
    REQUEST['basicmember_passwordpage']='ChangePasswordForm'
    REQUEST['basicmember_siteemail']='k_vertigo@yahoo.com'
    REQUEST['basicmember_sitename']='Python Repository'
    
    self.manage_addexUserFolder(authId='zodbAuthSource', 
                                propId='zodbPropSource',
                                memberId='basicMemberSource', 
                                cookie_mode=2, 
                                session_length=0, 
                                REQUEST=REQUEST)
    
    
def install_news(self, config=None):
    ob = NewsSink(NEWSID)
    self._setObject(NEWSID, ob)
    newssink = self._getOb(NEWSID)
    newssink._import_defaults()
    #newssink._set_active_defaults()
    #newssink.refresh_channels()


def install_packages(self, config=None):  
    ob = Packages.PackageApplication(PACKAGE_ID,PACKAGE_ID)
    ob.id = PACKAGE_ID
    ob.title = PACKAGE_ID
    self._setObject(PACKAGE_ID,ob)
    ob = self._getOb(PACKAGE_ID)

    event_channel = self.get_event_channel()
    
    ob.__of__(self)
    
    # make package storage folders
    _make_letter_containers(ob, Packages.PackageFolder)
    
    # make a misc one for numeric identity packages
    misc = Packages.PackageFolder('misc', 'misc')
    misc.id = 'misc'
    ob._setObject('misc', misc)
    
    # make package queue
    pq = Packages.PackageQueue('PackageQueue')
    ob._setObject('PackageQueue', pq)
    event_channel.register_source('package added to queue', ob)
    
    # make package upload process
    pu = Packages.PackageUpload(PACKAGE_UP_ID,PACKAGE_UP_ID) 
    ob._setObject(PACKAGE_UP_ID, pu)
    
    
def install_webservices(self, config={}):
    from Products.Gideon.Objects.WebServices import ServiceBroker
    id = config.get('WebServiceContainer', 'Services')
    
    ob = ServiceBroker.RepositoryServiceBroker(id)
    self._setObject(id, ob)
    
    ob = self._getOb(id)
    ob._install_defaults()

def install_tracker(self, config={}):
    from Products.Gideon.Objects.Tracker import Tracker
    id = config.get('Tracker', 'Tracker')

    ob = Tracker.Tracker(id)
    self._setObject(id, ob)

def install_documentation(self, config={}):
    import os
    from Products.Gideon.Objects.DocDirectory import DocDirectory
    from Products.Gideon import gideon_home

    id = config.get('DocDirectory', 'Documentation')
    path = os.path.join(gideon_home, 'doc')

    ob = DocDirectory.FileSystemDocumentation(id, id, path)
    self._setObject(id, ob)

    
def load_test_packages(self, config=None):
    # convience for mi
    # stick some packages in the queue    

    import os    
    from Products.Gideon.Objects.Packages.PackageInfo import PackageInfo
    from Products.Gideon.Objects.Packages.Package import Package
    from Products.Gideon.Objects.Packages.PackageVersion import PackageVersion
    from Products.Gideon import MetaDataParsers
    from Products.Gideon import gideon_home

    packagedir = os.path.join(gideon_home, 'var')
    infodir = os.path.join(packagedir, 'info')

    try: 
        packages = os.listdir(infodir)
    except: packages =[]
    
    package_container = self.get_application_for_name("Packages")
    queue = package_container.get_package_queue()

    for i in packages:
        
        rawinfo = MetaDataParsers.parse('PEP241', 'file', os.path.join(infodir,i))
        
        pi = PackageInfo(info=rawinfo)		
        p  = Package(pi.package_name())
        pv = PackageVersion(rawinfo.get('version'))     
        p.set_package_info(pi)
        
        queue.add_package(pi.package_name(), p)		
        
        p.get_version_container().add_version(pv)
        
        info_required = pi.get_remaining_required()
        version_required = pv.get_remaining_required()        

        
_funcs = [install_ui, install_event_channel,  install_mail_server,  
          install_packages, install_authors, install_categories,
          install_news, install_users_folder, install_users_directory,
          install_webservices, install_cookie_monster,  install_tracker,
          install_documentation, install_rating_service, load_test_packages]


            
def install_all(self):
    for f in _funcs:
        #print f
        f(self)
        
    
