"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $


from ApplicationObject import ApplicationObject
from Interface import Base
from AccessControl.Owned import Owned
from Acquisition import aq_base

#from Globals import DTMLFile

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log.Log import log

from IApplication import IApplication
from IRootApplication import IRootApplication


## subclass for contained applications
class RepositoryApplication(ApplicationObject, Folder):
    """ 
    this is about the simplest implementation, 
    it just uses the objectmanager interfaces
    to store services as attributes directly on the
    objects with service names as ids. meaning its
    just abstraction/overhead to normal acquisition...
    """
    __implements__ = (IApplication,) 
    
    _isApplication = 1
    
    def get_service(self, name, lookup=1):
        """ """
        if hasattr(self.aq_base, name):
            return getattr(self, name)
        
        elif lookup: # implemnent lookup acquisition application heirarchy
            app = self.get_inner_application(self, 2)
            return app.get_service(name, lookup)
        else:
            raise "No %s Service Found"%name
        
    def has_service(self, name, lookup):
        if hasattr(self.aq_base, name): return 1
        elif lookup: self.get_inner_application(self,2).has_service(name,lookup)
        return 0
    
    def register_service(self, name, object):
        ""
        self._setObject(name, object)
        

        
## class for container application    
manage_addPythonRepositoryForm = DTMLFile('dtml/manage_addPythonRepositoryForm',
					   globals())

def manage_addPythonRepository(self,
                               id,
                               title='',
                               REQUEST=None
                               ):
    """ this is a method with a docstring """
    self._setObject(id, PythonRepository(id, title))
    if REQUEST is not None: REQUEST.RESPONSE.redirect('manage_main')

# this is a special root application, it defines two key lookup
# functions in addition to the standard application interface
# that permit nested applications
# get_root_application - which will return das root app
# get_inner_application - to look for the nearest app to an object
  
class PythonRepository(RepositoryApplication):

    __implements__ = (IRootApplication,)
    
    security = ClassSecurityInfo()
    
    meta_type = 'Python Repository'

    security.declarePublic('index_html')
    index_html           = DTMLFile('dtml/RepositoryView', globals())    

    security.declarePublic('repository_style')
    repository_style     = DTMLFile('dtml/RepositoryStyle', globals())
    
    security.declarePublic('standard_html_header')
    standard_html_header = DTMLFile('dtml/RepositoryHeader', globals())

    security.declarePublic('standard_html_footer')
    standard_html_footer = DTMLFile('dtml/RepositoryFooter', globals())

    security.declarePublic('repository_style')    
    repository_style     = DTMLFile('dtml/RepositoryStyle', globals())

    def __init__(self, id, title):
        self.id = id
        self.title = title

    security.declarePublic('get_root_application')
    def get_root_application(self):
        return self
    
    security.declarePublic('get_context_application')
    def get_context_application(self, ob):
        """
        """
        while 1:
            if hasattr(aq_base(ob), '_isApplication'):
                return ob
            if hasattr(ob, 'aq_parent'): ob = ob.aq_parent
        
        raise "No Application Found"                
    
    security.declarePublic('get_inner_application')
    def get_inner_application(self, ob, level=1):
        """ 
        get the nearest application object, level if specified says how 
        many applications to go up from the object (default 1) 
        """
        if not hasattr(ob, 'aq_inner'): raise "Contained Object use Acquisition"

        ob = ob.aq_inner
        while 1:
            #print 'l', ob.getPhysicalPath()
            if hasattr(aq_base(ob), '_isApplication'): 
                if level == 1: return ob
                else: level -= 1
            if hasattr(ob, 'aq_parent'): ob = ob.aq_parent
            else: break
            
        raise "No Application Found"
    
    def get_application_for_name(self, name):
        return self._getOb(name)

    security.declarePublic('get_bread_crumb')    
    def get_bread_crumb(self):
        """ """
        res = []
        nodes = self.REQUEST.PARENTS[:-2]
        nodes.reverse()
        for n in nodes:
            res.append( (n.title_or_id(), n.absolute_url()))
        return res

    ## for the cookie crumbler#
    security.declarePublic('logout')
    def logout(self, REQUEST):
        """ """
        self.CookieMonster.logout()
        
    def get_login_url(self):
        """ """
        user_directory = self.get_application_for_name('Members')
        return user_directory.login_url()
    
    security.declarePrivate('setAuthCookie')
    def setAuthCookie(self, response, cookie_name, cookie_value, path='/'):
        log.debug('setting auth cookie %s %s %s'%(cookie_name, cookie_value, path))
        response.setCookie(cookie_name, cookie_value, path='/')
        
    security.declarePrivate('setAuthCookie')        
    def expireAuthCookie(self, response, cookie_name):
        log.debug('expiring auth cookie %s'%(cookie_name))
        response.expireCookie(cookie_name, path='/')
    ###########################,

    security.declarePrivate('manage_afterAdd')
    def manage_afterAdd(self, item, container): 
        import InstallationFuncs
        InstallationFuncs.install_all(self)
    
    ## depreciated 
    security.declarePublic('get_repository_url')        
    def get_repository_url(self):
        return self.absolute_url()
    
    def get_event_channel(self):
        return self.objectValues('Event Channel')[0]

    # for updates
    security.declarePublic('update')
    def update(self, REQUEST):
        """ """
        from Products.Gideon.Objects.Ratings import RatingService
        self._setObject('RatingService', RatingService.RatingService(
            'RatingService'))
                        
        return 1
        




