from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Objects.Application.PythonRepository import RepositoryApplication

class AuthorBrowser(SimpleItem):
    """
    temporary fix for authors
    
    traversal jaunx mostly taken from bindings.py
    """
    
    index_html = None 
    
    _author_packages = DTMLFile('ui/AuthorBrowserView', globals())
    
    def __init__(self, id):
        self.id = id
    
    def __before_publishing_traverse__(self, self2, request):
        path = request['TraversalRequestNameStack']

        if path and hasattr(self.aq_explicit, path[-1]):
            return
        
        subpath = path[:]
        path[:] = []
        subpath.reverse()
        request.set('traverse_subpath', subpath)
    
    def _get_traverse_subpath(self):
        
        if hasattr(self, 'REQUEST'):
            return self.REQUEST.other.get('traverse_subpath', [])
        else:
            return []
        
    def __call__(self, REQUEST):
        subpath = self._get_traverse_subpath()
        
        if subpath:
            author = subpath.pop()
            
        packages = self.get_inner_application(self).get_packages_by_author(author)
        
        if not packages: # bad request
            REQUEST.RESPONSE.redirect(self.aq_inner.aq_parent.absolute_url())
            
        return self._author_packages(author=author,packages=packages)
        

class AuthorContainer(RepositoryApplication):
    
    meta_type = "Author Container"
    
    security = ClassSecurityInfo()

    security.declarePublic('index_html')
    index_html = DTMLFile('ui/AuthorContainerView',globals())

    def fix(self, REQUEST):
        """ """
        self._setObject('Browse', AuthorBrowser('Browse'))
        REQUEST.RESPONSE.redirect('.')
    
    security.declarePublic('get_authors')
    def get_authors(self, REQUEST=None):
        """ """
        #catalog = self.get_application_for_name('Packages').get_service("PackageCatalog")        
        #res = catalog.uniqueValuesFor('package_authors')
        res = self.Packages.PackageCatalog.uniqueValuesFor('package_authors')
        return res
    
    security.declarePublic('get_packages_by_author')
    def get_packages_by_author(self, author):
        """ """
        packageapp = self.get_application_for_name('Packages')
        return packageapp.get_packages_for_author(author)

    def _package_published(self, event, package, *args):
        authors  = package.get_package_info().package_authors()
        
    
    def manage_afterAdd(self,item, container):
        self._setObject('Browse', AuthorBrowser('Browse'))
        channel = self.get_root_application().get_service('EventChannel')
        #channel.register_listener('package published', self, '_package_published')
        
def make_author_id(first_name, last_name):
    # cheesy
    return first_name.lower()+last_name.lower()
        
class Author(Folder):
    
    meta_type = "Package Author"
    
    index_html = DTMLFile('ui/AuthorView', globals())
    
    def __init__(
                    self,
                    id,
                    first_name, 
                    last_name,
                    public_email,
                    private_email='',
                    home_url='',
                    ):
        
        self.id = id
        self.first_name = first_name
        self.last_name  = last_name
        self.public_email = public_email
        self.home_url = home_url
        
    def get_packages_by_author(self):
        return self.get_package_container().related_by_author(self)
    
