#!/usr/local/bin/python

import ConfigParser  
import os 
import sys
import getopt
from string import replace,strip

from Util import system_exit

""" Todo
1. Need to fix environment variables to accept upper case variants
2. need to be able to specify allowable values of options for 
   configuration verification.
"""



class AppConfiguration:
	
	""" AppConfiguration
	
	a central location for app environment information
	
	1. reads through config file to parse options
	2. reads environment variables
	3. reads command line options	
	
	"""
	
	# configuration options
	appname=''
	required_options=()
	command_line_options=()
	command_line_options_long=()
	environ_options=()

	def __init__(self, appname, app_config):
		
		self.config_files = app_config['config_files']
		self.required_options = app_config['required_options']
		self.environ_options = app_config['environ_options']
		self.command_line_options=''
		self.command_line_options_long = app_config['command_line_options_long']
		self.approot=os.path.abspath(os.pardir)
		self.doc_string = app_config['doc_string']
		self.config_info = {}	

		
	def setup(self):
		for file in self.config_files:
			self._read_config_file(file)
			
		self._read_environment_variables()
		self._read_commandline_options()
		self._verify_good_configuration()
		print self.config_info
		
	def _read_config_file(self, config_file='openacs_tools.conf'):
			
		cparser = ConfigParser.ConfigParser()
		config_file=os.path.join(self.approot,'config',config_file)

		try:
			cparser.read([config_file])
		except IOError:
			system_exit("Fatal Exception: Can't Find Config File")
		
		sections=cparser.sections()
		
		# flatten sections into global dictionary
		for section in sections:
			try:
				info = cparser.options(section) # don't want __name__
				info.pop(info.index('__name__'))
			except ValueError: pass # python2+ implements imo proper behavior
			
			for key in info:			
				self._add_config_option(key, cparser.get(section,key))
			
		del cparser
		
	def _read_environment_variables(self): 

		env=os.environ.keys()
		for option in self.environ_options:
			if option in env:
				self._add_config_option(option,os.environ[option])

	
	def _read_commandline_options(self): 		
		options, args = getopt.getopt(sys.argv[1:],
		              self.command_line_options,
		              self.command_line_options_long)
		
		for option in options:
			#print option 
			option_name = replace(option[0], '-','')
			#print option_name, option[1]
			if option[1]:
				self._add_config_option(option_name,strip(option[1]))
			else:
				self._add_config_option(option_name,1)

	def _verify_good_configuration(self):
		options = self.config_info.keys()
		#print self.config_info
		for required in self.required_options:
			if not required in options:
				system_exit("%s\n\n%s"%(self.appname, self.doc_string))
			
				#system_exit("Fatal Exception: %s Configuration Can't Find %s Required Option"%(
				#				self.appname,
				#				required))
				
				
	
	def _add_config_option(self, name, option):
		if self.config_info.has_key(name):
			print "%s option already exists, replacing"%name
			self.config_info[name]=option			
		else:
			self.config_info[name]=option			

	
if __name__ == '__main__':
	import pprint
	
	appc = AppConfiguration()
	appc.setup()	
	pprint.pprint(appc.config_info)
	
	
