"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

"""
currently this just implements a transactional mailer
not a bulk txn mailer... and since email isn't transactional
its not even transactional ;)

what it does is try to send out the email at the last
possible moment within a zope transaction.

the bulk variant will dump into a queue directory
and launch a sweeper process on startup, as well
as adding additional methods for mass mailing

todo:
  application api for registering interest in status
  of batches/groups of messages. perhaps it should explicitly
  turned on per txn. 
"""
import os
import smtplib

from cStringIO import StringIO
from cPickle import dump

from ComputedAttribute import ComputedAttribute
from Shared.DC.ZRDB.TM import TM

from Products.MailHost.MailHost import *

from Products.Gideon import gideon_home
from Products.Gideon.Objects.Namespace import *
from Products.Gideon.FileSystem.TransactionalFileSystem \
     import TransactionalFileSystem

mailfs = TransactionalFileSystem(
    os.path.join( gideon_home, 'var', 'mail', 'queue' ),
    os.path.join( gideon_home, 'var', 'mail', 'temp' )
    )

class Mail:
    
    def __init__(self, from_, to, message_text):
        self.from_ = from_
        self.to = to
        self.message_text = message_text

    def sendmail_vars(self):
        return [self.from_, self.to, self.message_text]
        
# txn registration    
class TxnMailerRegistration(TM):
    
    def __init__(self, host, port):
        self.host = host
        self.port = port
        self.server = None
        self._store = []    
        
    def add_message(self, mail):
        self._register()
        self._store.append(mail)
    
    def tpc_vote(self, txn):
        """last chance to bail before we hose the app"""
        
        server = SMTP(self.host, self.port)

        for m in store: 
            apply(self.server.sendmail, m.sendmail_vars())
            
        self._finish()
            
    def _finish(self, *args):
        self._store = []
    
    def _abort(self, *args):
        self._store = []

        
class TransactionalMailer(SimpleItem, MailBase):
    """ 
    really this is a 'mostly transactional' mailer, it defers
    sending to the end of a transaction. real txn integrity 
    it impossible with email.
    """
    
    def __init__(self, id, host, port):
        
        self.id = id
        self.smtp_host = host
        self.smtp_port = port
    
    def _v_store(self):
        
        v = self._v_store = \
            TxnMailerRegistration(self.smtp_host, self.smtp_port)
        
        return v
    
    _v_store = ComputedAttribute(_v_store)

    def send(self,
             messageText,
             mto=None,
             mfrom=None,
             subject=None,
             encode=None):

        headers, messageText = format_message(messageText,
                                              mto,
                                              mfrom,
                                              subject,
                                              encode)
        
        self._v_store.add_message(
            Mail(headers['from'],headers['to'], messageText)
            )
        

class BulkTransactionalMailer(SimpleItem, MailBase):
    
    """ 
    uses txn fs to ensure that mail is not queue'd for
    delivery unless the transaction commits. requires
    an exteral queue watcher to watch the queue.
    """

    index_html = None
    __call__ = None

    def __init__(self, id, host, port):
        self.id = id
        self.smtp_host = host
        self.smtp_port = port
    
    def _v_store(self): 
        v = self._v_store = mailfs
    
    _v_store = ComputedAttribute(_v_store)

    def _v_next_mid(self):
        """
        avoid some extra calls to randid
        """
        self._v_next_mid = mid = randind()
        return mid    

    _v_next_mid = ComputedAttribute(_v_next_mid)

    def send(self,
             messageText,
             mto=None,
             mfrom=None,
             subject=None,
             encode=None):
        
        headers, messageText = format_message(messageText,
                                              mto,
                                              mfrom,
                                              subject,
                                              encode)

        mid = str(self._v_next_mid)
        self._v_next_mid += 1
        
        message = Mail(headers['from'],headers['to'], messageText)
        message.host = host
        message.port = port
        
        message_pickle = StringIO()
        dump(message, message_pickle, 1)
        
        self._v_store.add_file_object(message_pickle, message_id)


## utility format method culled from mail host        

def format_message(
                 messageText,
                 mto=None,
                 mfrom=None,
                 subject=None,
                 encode=None):
    
        headers = extractheaders(messageText)
        
        messageText = messageText.lstrip()

        if not headers['subject'] and len(headers)==0:
            messageText="subject: %s\n\n%s" % (subject or '[No Subject]',
                                             messageText)

        elif not headers['subject']: 
            messageText="subject: %s\n%s" % (subject or '[No Subject]',
                                             messageText)


        if mto:
            if type(mto) is type('s'):
                mto=map(string.strip, string.split(mto,','))
            headers['to'] = filter(None, mto)
        if mfrom:
            headers['from'] = mfrom
            
        for requiredHeader in ('to', 'from'):
            if not headers.has_key(requiredHeader):
                raise MailHostError,"Message missing SMTP Header '%s'"\
                      % requiredHeader
        messageText=_encode(messageText, encode)

        return heaaders, messageText
