"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.Cache import Cacheable
from OFS.SimpleItem import SimpleItem
from AccessControl import ClassSecurityInfo
from Acquisition  import Implicit
from Globals import DTMLFile
from BTrees.IIBTree import IISet 
from BTrees.Length import Length

_marker = []

class CacheCounter(Length):
    
    def _p_resolveConflict(self, old, saved, new):
        return new

class UninitializedQuery(Exception): pass

class CacheQuery(Cacheable, SimpleItem, Implicit): 

    """
    A Simple Caching Catalog Query Cache.
    """

    meta_type = 'Catalog Query'
    
    security = ClassSecurityInfo()
    
    def __init__(self, id, catalog_path='', query=''):
        self.id = id
        self._catalog_path = catalog_path
        self._query = query
        self._size = CacheCounter() 

    def set_catalog(self, catalog_path):
        if type(catalog_path) is type(()):
            catalog_path = '/'.join(catalog_path)
        self._catalog_path = catalog_path

    def get_catalog(self):
        return self.unrestrictedTraverse(self._catalog_path)
        
    def set_query(self, query):
        self._query = query
        
    def size(self):
        return self._size()

    def execute(self):
        """ """
        result = _marker # don't use, reassign
        keyset = None
        
        if not self._query or not self._catalog_path:
            raise UninitializedQuery("query not ready")
        
        # possibly raising error, 
        catalog = self.get_catalog()
        
        if self.ZCacheable_isCachingEnabled():
            keyset = {'obj_path':self.getPhysicalPath(), 'query':self._query}
            result = self.ZCacheable_get(keywords=keyset, default=_marker)
            
            getbrain = catalog._catalog.__getitem__
            
            # a cached result could easily throw a key error..
            if result is not _marker: 
                try:
                    return map(getbrain, result)
                except KeyError: # ok lets run the real query
                    pass
                
        result = catalog(self._query)

        self._size.set(len(result))
        
        if result is None: return []

        if keyset is not None:
            cache_results = IISet( map( lambda x: x.data_record_id_, result ))                
            self.ZCacheable_set(cache_results, keywords=keyset)
            
        return result
