"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $


from Products.ZCatalog.ZCatalog import ZCatalog
from UserDict import UserDict

class CatalogSchema(UserDict):

    def __init__(self, indexes={}, columns=[]):
        self.indexes = indexes
        self.columns  = columns
        UserDict.__init__(self)
    
def extract_query(REQUEST, schema):
    res = {}
    for i in schema.indexes.keys():
        if REQUEST.has_key(i): res[i]=REQUEST[i]       
        
    return res

def merge_schemas(s1, s2):

    mschema = CatalogSchema()

    mcols = []
    addcol = mcols.append
    
    s1cols = s1.columns
    s2cols = s2.columns
    
    [addcol(col) for col in s1cols if col not in s2cols]
    [addcol(col) for col in s2cols if col not in mcol]

    mschema.columns = mcols

    mindexes = {}
    s1idx = s1.indexes
    s2idx = s2.indexes

    mindexes.update(s1idx)
    mindexes.update(s2idx)

    mschema.indexes = mindexes

    return mschema
    

default_indexes = {
    'PrincipaSearchSource':'',
    'assigned_user':'',
    'bobobase_modification_time':'',
    'title':'',
    'meta_type':'',
    'path':''                   
}

default_columns = [
    'bobobase_modification_time',
    'summary',
    'id',
    'title'                   
]                  

default_schema = CatalogSchema(default_indexes, default_columns)


def remove_catalog_schema(catalog, schema):
    catalog.manage_delIndex(ids = schema.indexes.keys())
    catalog.manage_delColumn(ids = schema.columns)

def install_catalog_schema(id, schema, obj, remove_default=0):

    cat = ZCatalog(id, id)

    obj._setObject(id, cat)

    cat = getattr(obj, id)

    if remove_default:
        remove_catalog_schema(cat, default_schema)

    
    getidx = schema.indexes.get
    for idx in schema.indexes.keys():
        cat.addIndex(idx, getidx(idx))

    for col in schema.columns:
        cat.addColumn(col)
    
                     
author_indexes = {

    'id': 'FieldIndex',
    'first_name': 'TextIndex',
    'last_name':  'TextIndex',
    'public_email': 'TextIndex',
    'author_url': 'FieldIndex',
    'SearchableText': 'FieldIndex'

}


package_queue_index = {
    'creator': 'FieldIndex',
    'package_name':'FieldIndex',
    'assigned':'FieldIndex'                       
}

package_indexes = {

    'package_name' :'FieldIndex',
    'package_description' : 'TextIndex',
    'package_summary':'TextIndex',
    'package_url' : 'FieldIndex',
    'package_authors':'KeywordIndex',
    'package_company':'FieldIndex',
    'package_keywords':'KeywordIndex',
    'package_categories':'KeywordIndex',
    '_get_package_state':'FieldIndex',
    'SearchableText': 'TextIndex'
    
}

package_columns = {
    'package_name' :'FieldIndex',
    'package_summary':'TextIndex',
    'package_url' : 'FieldIndex',
    'package_authors':'KeywordIndex',
    'package_company':'FieldIndex',
    'package_keywords':'KeywordIndex',
    'package_categories':'KeywordIndex',
}

user_indexes = {
    
    'id' : 'FieldIndex',
    'first_name': 'FieldIndex',
    'last_name': 'FieldIndex',
    'SearchableText':'TextIndex'

}    
    

_registered_schemas = map( CatalogSchema, [ user_indexes, package_indexes, author_indexes ])

def register_schema(schema):
    if not _registered_schemas.count(schema) > 0:
        _registered_schemas.append(CatalogSchema(schema, []))

        
def get_default_schema():
    return reduce(merge_schemas,  _registered_schemas)

if __name__ == '__main__':
    print get_default_schema().indexes
