"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.SimpleItem import SimpleItem

from operator import add

class DistributedCatalogQuery(SimpleItem):
    """
    allows simple searching across a set of
    catalogs, returning a lazy concat of search
    results, with concat ordered upon
    a list of catalogs passed in to query,
    or not at all if searching through all
    catalogs.
    """
    

    def __init__(self):
        
        self._catalogs = PersistentMapping()
        
    def query(self, query, catalogs=[]):

        if not catalogs:
            catalogs = self._catalogs.values()
        else:
            catalogs = map(self._catalogs.__getitem__, catalogs)
        
        cats = map(lambda x: x.get_object(), catalogs)
        
        return map(add, [c.searchResults(**query) for c in cats])
            
    def register_catalog(self, name, catalog):
        
        objref = self.get_service('ObjectLinkingService').get_reference(catalog)
        self._catalogs['name']=objref
        
    
    def unregister_catalog(self, name):

        if self._catalogs.has_key(name):
            del self._catalogs[name]
    
        
