"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Products.Gideon.Objects.Namespace import *  
from Products.Gideon.Objects.Application.PythonRepository import RepositoryApplication
from Products.Gideon.Objects.Catalog.CacheQuery import CacheQuery

from OFS.Folder import Folder 
from OFS.Cache import Cacheable
from Acquisition  import Implicit
from Globals import DTMLFile
from BTrees.IIBTree import IISet 

class Category(Folder): 
    
    meta_type = 'Category'

    index_html = DTMLFile('ui/CategoryView', globals())
    
    def __init__(self, id, title):
        self.id = id
        self.title = title

    def get_category_packages(self):
        """ returns catalog brains """
        return self._query.execute()
    
    def get_subcategories(self):
        return self.objectValues('Category')
    
    def manage_afterAdd(self, item, container):
        catalog = self.get_application_for_name("Packages").get_service("PackageCatalog")
        expr = {'package_categories':self.title}
        self._query = CacheQuery('_query', '/'.join(catalog.getPhysicalPath()), expr)
        
"""
class CategoryContainerEventProxy(SimpleItem):        
    
    def __init__(self, id):
        self.id = id

    def notify_categories_of_changes(self, package, *args):
        cats = package.get_package_info().package_categories()
        
        # get all the categories
        catmap = {}
        [catmap[c.getId()]=c for c in self.get_all_categories()]

        for c in cats:
            if not catmap.has_key(c): raise AttributeError('nvalid category')
            
        pass
    
    def manage_afterAdd(self, item, container):
        channel = self.get_service('EventChannel')
        channel.register_listener()
"""        
    

class CategoryContainer(RepositoryApplication): 
    
    meta_type = 'Category Container'
    
    index_html = DTMLFile('ui/CategoryContainerView', globals())

    security = ClassSecurityInfo()
    
    def dispatch(self, REQUEST):
        """ redirect dispatching based on category id"""
        if REQUEST.has_key('category_id'):
            c = filter(lambda x,y=REQUEST['category_id']: x.getId()==y, self.get_all_categories())
            if c:
                REQUEST.RESPONSE.redirect(c[0].absolute_url())
                return

        ## fall through and send them to the category folder
        REQUEST.RESPONSE.redirect(self.absolute_url())
    
    def get_all_categories(self, start=None):
        # superValues doesn't seem to work, so we get functional
        if not start: start = self
        res = start.objectValues('Category')
        map(res.extend, map(self.get_all_categories, res))
        return res


        
   

        
    