"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from xml.sax import make_parser, ContentHandler

from Categories import Category

class CategoryHandler(ContentHandler):
    """
    instantiates categories from a simple
    xml file
    """
    
    def __init__(self, obj):
        
        self._stack = []
        self._stack.append(obj)

    def startElement(self, name, attrs):
        
        if name != 'category': return
        
        n = str(attrs.get('name'))
        id = n.replace(' ', '')
        #print "Creating", n, id
        if n:
            ob = Category(id,n)
            container = self._stack[-1]
            container._setObject(id, ob)
            self._stack.append(getattr(container, id))

    def endElement(self, name):
        if name == 'category':
            self._stack.pop()
            
    def endDocument(self):
        del self._stack # free root wrapper reference
            
if __name__ == '__main__':
    import sys

    if not len(sys.argv) > 1:
        print 'usage CategoryLoader categoryxmlfile'
        
    p = make_parser()
    h = CategoryHandler(1)
    p.setContentHandler(h)
    p.parse(sys.argv[1])
    