"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

import os
import glob

from ComputedAttribute import ComputedAttribute

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log import LogFactory

log = LogFactory('Documentation')

class STXDocumentation(SimpleItem):

    meta_type = 'FSSTX Documentation'

    def _v_stx(self):
        
        try:
            fh = open(self.path)
        except:
            log.warning('Documentation Not Found %s'%self.path)
            return ''

        stx = self._v_stx = fh.read()

        return stx

    _v_stx = ComputedAttribute(_v_stx)

    index_html = DTMLFile('ui/STXDocumentationView', globals())

    def __init__(self, id, path):
        self.id = id
        self.path = path

    def get_content(self):
        return self._v_stx

class FileSystemDirectoryDocumentation(Folder):

    meta_type = 'FileSystem Documentation Directory'

    index_html = DTMLFile('ui/FileSystemDocDirectoryView', globals())

    def __init__(self, id, path):
        self.id = id
        self.path = path

    def load_documentation(self):
        
        files = glob.glob(self.path+'/*stx')

        for f in files:
            id = os.path.basename(f)[:-4]
            try:
                self._setObject(id,
                                STXDocumentation(
                                   id, os.path.join(self.path, f)
                                   )
                                )
            except:
                log.warning('error loading documentation for %s'%f)

    def manage_afterAdd(self,item, container):
        
        self.load_documentation()

class FileSystemDocumentation(Folder):

    meta_type = 'FileSystem Documentation'

    index_html = DTMLFile('ui/FileSystemDocumentationView', globals())

    def __init__(self, id, title, path):
        self.id = id
        self.title = title
        self.path = path
        
    def load_documentation(self):
        
        log.debug('loading documentation')
        
        docdirs = os.listdir(self.path)

        for d in docdirs:

            if d == 'CVS': continue
            
            self._setObject(
                d,
                FileSystemDirectoryDocumentation(
                    d, os.path.join(self.path, d)
                    )
                )

    def manage_afterAdd(self, item, container):
        
        self.load_documentation()
            



