"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

" filter validation proc "

import inspect 
from types import StringType

from EventChannelExceptions import BadFilterType

def validate_filter(context, object, filter_name):

    if type(object) is StringType:
        # we should get the object since we would have errored
        # out before
        try: object = context.unrestrictedTraverse(object)
        except: return

    if not filter_name:
        return 1

    if type(filter_name) is not StringType:
        raise BadFilterType ( " Filters must be strings " )

    elif not hasattr(object, filter_name):
        raise NoFilterFound (
            """ objects must implement registered filters, or
            filters should be in the context of the object """
            )

    filter = getattr(object, filter_name)

    if not callable(filter):
        raise BadFilterType ( " Filters must be callable ")

    if inspect.isfunction(filter): pass
    elif inspect.ismethod(filter): pass

    return 1
        

