"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

# File: eventlog.py
# Author: Kapil Thangavelu
# License: GPL
# CVS: $Id: eventlog.py,v 1.1.1.1 2001/12/31 04:07:06 ender Exp $
# Description: simple logging singleton

import time
from threading import Lock
l = Lock()
_a = l.acquire
_r = l.release
del l

class EventLog:
    
    LOGLEVEL=4
    LOGFILE='/home/ender/orion/Gideon/Objects/EventChannel/log.txt'
    
    _levels = {}
    _levels['debug']=3
    _levels['warning']=2
    _levels['critical']=1    
    
    def __init__(self):
        self.fh = open(self.LOGFILE, 'wr')
    
    def _log(self,msg,level, type):
        #if self.LOGLEVEL>level:
        _a()
        try:
            msg = "[%s] %s: %s\n"%( time.ctime(time.time()), type, str(msg))               
            print msg
            self.fh.write(msg)
            self.fh.flush()
        finally:
            _r()

    def warning(self,msg):
        self._log(msg, self._levels['warning'], 'warning')
                  
    def debug(self,msg):
        self._log(msg, self._levels['debug'], 'debug')
        
    def critical(self,msg):
        self._log(msg, self._levels['critical'], 'critical')

log=EventLog()
del EventLog
