"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.Folder import Folder
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import SimpleItem
from OFS.History import Historical
from Globals import DTMLFile, InitializeClass
from AccessControl import ClassSecurityInfo

from Presentation.Common import get_event_channel

class EventMappingContainer(Folder): 
    
    meta_type = 'Event Mapping Container'

    security = ClassSecurityInfo()

    manage_options = (
        
        {'label':'Event Type Mappings',
         'action':'manage_main',
         'help':('EventChannel', 'EventMapping.stx')
         },
        
        {'label':'Event Channel', 'action':'../manage_overView'},
         
        )

    manage_main = DTMLFile('dtml/EventMapping', globals())

    def __init__(self, id, title=''):
        self.id = id
        self.title = title

    security.declareProtected('Manage Event Channel', 'get_event_channel')
    def get_event_channel(self):
        return get_event_channel(self)

    security.declareProtected('Manage Event Channel', 'add_mapping')
    def add_mapping(self, event_type_start, event_types_end, REQUEST=None):
        """ """
        if event_type_start in event_types_end:
            event_types_end.remove(event_type_start)

        if event_types_end:
            self._setObject(event_type_start, EventMapping(event_type_start,
                                                           event_types_end))

        if REQUEST is not None:
            REQUEST.RESPONSE.redirect('manage_main'+'?message=mapping+added')

    security.declareProtected('Manage Event Channel', 'edit_mapping')        
    def edit_mapping(self, event_type_start, event_types_end):
        mapping = self._getObj(event_type_start)
        mapping.targets = event_types_end

    security.declareProtected('Manage Event Channel', 'delete_mapping')
    def delete_mapping(self, event_type_start, REQUEST=None):
        """ """
        if event_type_start in self.objectIds('Event Mapping'):
            self._delObject(event_type_start)

        if REQUEST is not None:
            REQUEST.RESPONSE.redirect('manage_main'+'?message=mapping+deleted')

    security.declarePrivate('get_mapping_types')
    def get_mapping_types(self, event_type_start):
        mapping = self._getOb(event_type_start, None)
        if mapping: return mapping.targets
        return []

InitializeClass(EventMappingContainer)    
    
class EventMapping(SimpleItem):

    meta_type = 'Event Mapping'


    manage_options = (
        {'label':'Mapping Contents',
         'action':'manage_main',
         'help':('EventChannel', 'EventMapping.stx')
         },
        {'label':'Event Mappings',
         'action':'../manage_main',
         },
        {'label':'Event Channel', 'action':'../../manage_overView'},
        
        )
    
    security = ClassSecurityInfo()

    manage_main = DTMLFile('dtml/EventMappingView', globals())
    
    def __init__(self, id, targets):
        self.id = id
        self.targets = targets
        
    
InitializeClass(EventMapping)    




    
