#
from BTrees.OISet import OISet

from Products.PluginIndexes.common.randid import randid

from Products.Gideon.Objects.Namespace import *

class EventProxy(SimpleItem):

    def __init__(self, id, event_type, objref, location, date):
        self.id = id
        self.event_type = event_type
        self.location = location
        self.creation_date = date
        self.objref = objref

ep_indexes = {
    'id':'FieldIndex'
    'location':'PathIndex',
    'event_type':'FieldIndex',
    'creation_date':'FieldIndex'
    }

ep_columns = []

ep_schema = CatalogSchema.CatalogSchema(spe_indexes, spe_columns)    

class CatalogedEventQueue(SimpleItem):

    meta_type = 'Cataloged Event Queue'

    event_types = ()

    def __init__(self, id, title=''):
        self.id = id
        self.title = title

        self._queue = IOBTree()
        self._queue_size = Length()

    def search_events(self, **kw):
        
        return self.EventQueueCatalog(**kw)

    def add_event_proxy(self, event_proxy):
        
        self._queue.insert(event_proxy.id, event_proxy)
        self._queue_size.change(1)

    def remove_event_proxy(self, id):
        
        if self._queue.has_key(id):
            del self._queue[id]

    def __getitem__(self, name):
        return self._queue[name]
    
    def notify(self, obj, listener, event_type):
    
        obj_location = '/'.join(obj.getPhysicalPath())
        obj_ref = self.get_service('ObjectLinkingService').get_reference(obj)
        event_date = DateTime()
        proxy_id = randid()
        
        proxy = EventProxy(proxy_id,
                           event_type,
                           obj_location,
                           obj_ref,
                           event_date)
        
        self.add_event_proxy(proxy)
        
        
    def manage_afterAdd(self, item, container):

        CatalogSchema.install_catalog_schema(
            self,
            'EventQueueCatalog'
            ep_schema
            1)

        channel = self.get_service('EventChannel')
        
        for et in self.event_types:
            channel.register_listener(self, 'notify', et)
        



        
                                 


