"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.SimpleItem import SimpleItem
from Globals import DTMLFile, InitializeClass
from AccessControl import ClassSecurityInfo
from ExtensionClass import Base
from Acquisition import Implicit
from Common import *


class EventListenerTraverse(Implicit):

    view_event_listener = DTMLFile('dtml/EventListenerView', EventChannelHome)

    index_html = None

    def __init__(self, name):
        self.name = name

    def __call__(self, REQUEST=None):
        """ """
        return self.view_event_listener(self,
                                        REQUEST,
                                        event_listener=self.name)
        
class EventListenerPresentation(SimpleItem):

    meta_type = 'Event Listener Management'

    manage_options = (
        {'label':'Event Listeners',
         'action':'manage_main',
         'help':('EventChannel', 'EventListeners.stx')
         },
        
        {'label':'Event Channel', 'action':'../manage_overView'},
         
        )
    
    manage_main = DTMLFile('dtml/EventListenerManagement', EventChannelHome)

    security = ClassSecurityInfo()

    security.declarePrivate('get_event_channel')
    def get_event_channel(self):
        
        return get_event_channel(self)

    security.declareProtected('Manage Event Channel', 'add_event_listener')
    def add_event_listener(self,
                           event_listener,
                           event_method,
                           event_type,
                           event_filter=None,
                           REQUEST=None
                           ):
        """ """

        channel = get_event_channel(self)
        channel.register_listener(event_listener,
                                  event_method,
                                  event_type,
                                  event_filter)
        

        REQUEST.RESPONSE.redirect('manage_main'+'?message=listener+added')
        
    security.declareProtected('Manage Event Channel', 'remove_event_listener')
    def remove_event_listener(self,
                              event_listener,
                              event_type=None,
                              REQUEST=None
                              ):
        """ """
        
        channel = get_event_channel(self)
        channel.unregister_listener(event_listener, event_type)

        REQUEST.RESPONSE.redirect('manage_main'+'?message=listener+removed')
        
    security.declareProtected('Manage Event Channel', 'get_listener_info')
    def get_listener_info(self, listener):
        
        channel = get_event_channel(self)
        registrations = channel.get_listener_registration(listener)
        
        return registrations
        
    def __before_publishing_traverse__(self, other, request):
        path = request['TraversalRequestNameStack']
        if path and hasattr(self.aq_explicit, path[-1]):
            return
        
        subpath = path[:]
        path[:] = []
        subpath.reverse()

        request.set('event_listener_id', subpath)

    def __bobo_traverse__(self, REQUEST, name=None):
        
        if not REQUEST.has_key('event_listener_id'):
            return getattr(self, name)

        name = '/'+'/'.join(REQUEST['event_listener_id'])
        
        event_listeners = get_event_channel(self).get_event_listeners()
        
        if name in event_listeners:
            return EventListenerTraverse(name).__of__(self)

        raise "Not Found"

InitializeClass(EventListenerPresentation)    
