"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.SimpleItem import SimpleItem
from Globals import DTMLFile, InitializeClass
from AccessControl import ClassSecurityInfo
from ExtensionClass import Base
from Acquisition import Implicit
from Common import *

class EventSourceTraverse(Implicit):

    view_event_source = DTMLFile('dtml/EventSourceView', EventChannelHome)

    index_html = None

    def __init__(self, name):
        self.name = name

    def __call__(self, REQUEST=None):
        """ """
        return self.view_event_source(self,
                                        REQUEST,
                                        event_source=self.name)
        
class EventSourcePresentation(SimpleItem):

    meta_type = 'Event Source Management'

    manage_options = (
        {'label':'Event Sources',
         'action':'manage_main',
         'help':('EventChannel', 'EventSources.stx')
         },
        
        {'label':'Event Channel', 'action':'../manage_overView'},
         
        )
    
    manage_main = DTMLFile('dtml/EventSourceManagement', EventChannelHome)

    security = ClassSecurityInfo()

    security.declarePrivate('get_event_channel')
    def get_event_channel(self):
        
        return get_event_channel(self)

    security.declareProtected('Manage Event Channel', 'add_event_source')
    def add_event_source(  self,
                           event_source,
                           event_type,
                           REQUEST=None
                           ):
        """ """

        channel = get_event_channel(self)
        channel.register_source(event_source, event_type)

        REQUEST.RESPONSE.redirect('manage_main'+'?message=source+added')
        
    security.declareProtected('Manage Event Channel', 'remove_event_source')
    def remove_event_source(self,
                              event_source,
                              event_type=None,
                              REQUEST=None
                              ):
        """ """
        
        channel = get_event_channel(self)
        channel.unregister_source(event_source, event_type)

        REQUEST.RESPONSE.redirect('manage_main'+'?message=source+removed')
        
    security.declareProtected('Manage Event Channel', 'get_source_info')
    def get_source_info(self, source):
        
        channel = get_event_channel(self)
        registrations = channel.get_source_registration(source)
        
        return registrations
        
    def __before_publishing_traverse__(self, other, request):
        path = request['TraversalRequestNameStack']
        if path and hasattr(self.aq_explicit, path[-1]):
            return
        
        subpath = path[:]
        path[:] = []
        subpath.reverse()

        request.set('event_source_id', subpath)

    def __bobo_traverse__(self, REQUEST, name=None):
        
        if not REQUEST.has_key('event_source_id'):
            return getattr(self, name)

        name = '/'+'/'.join(REQUEST['event_source_id'])
        
        event_sources = get_event_channel(self).get_event_sources()
        
        if name in event_sources:
            return EventSourceTraverse(name).__of__(self)

        raise "Not Found"

InitializeClass(EventSourcePresentation)    
