"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.SimpleItem import SimpleItem
from Globals import DTMLFile, InitializeClass
from AccessControl import ClassSecurityInfo
from ExtensionClass import Base
from Acquisition import Implicit
from Common import *

class EventTypeTraverse(Implicit):

    view_event_type = DTMLFile('dtml/EventTypeView', EventChannelHome)

    index_html = None

    def __init__(self, name):
        self.name = name

    def __call__(self, REQUEST=None):
        """ """
        return self.view_event_type(self, REQUEST, event_type=self.name)
        
class EventTypePresentation(SimpleItem):

    meta_type = 'Event Type Management'

    manage_options = (
        {'label':'Event Types',
         'action':'manage_main',
         'help':('EventChannel', 'EventTypes.stx')
         },
        
        {'label':'Event Channel', 'action':'../manage_overView'},
         
        )
    
    manage_main = DTMLFile('dtml/EventTypeManagement', EventChannelHome)

    security = ClassSecurityInfo()

    security.declarePrivate('get_event_channel')
    def get_event_channel(self):
        
        return get_event_channel(self)

    security.declareProtected('Manage Event Channel', 'add_event_type')
    def add_event_type(self, event_type, REQUEST):
        """ """

        channel = get_event_channel(self)
        channel.register_event_type(event_type)

        REQUEST.RESPONSE.redirect('manage_main'+'?message=event_type+added')
        
    security.declareProtected('Manage Event Channel', 'remove_event_type')
    def remove_event_type(self, event_type, REQUEST):
        """ """
        
        channel = get_event_channel(self)
        channel.unregister_event_type(event_type)

        REQUEST.RESPONSE.redirect('manage_main'+'?message=event_type+removed')

    def __bobo_traverse__(self, REQUEST, name=None):
        event_types = get_event_channel(self).get_event_types()
        if name in event_types:
            return EventTypeTraverse(name).__of__(self)
        return getattr(self, name)

InitializeClass(EventTypePresentation)    
