"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Products.Gideon.Objects.Namespaces import *

from BTrees.OIBTree import OISet
from Interfaces import Base

class IEventProxy(Base):

    def get_event_type(self): 
        """ get the event type """
    
    def get_event_source(self): 
        """ get the source of the event """

    def get_event_time(self):
        """ get the time the event was created """
    
class EventQueue(Folder):
    """ simple FIFO event list """
    
    meta_type = 'Event Queue'
    
    security = ClassSecurityInfo()

    def __init__(self, id='EventQueue'):
        self.id = id
        self._data = OISet()
        
    def add_event(self, event):
        if IEventProxy.implementedBy(event):
            self._data.insert(event)
        else: raise "Event does not support Event Proxy Interface"

    def get_filtered_events(self, event_filter):
        return map(event_filter, self._data)
        
    def remove_event(self, i):
        self._data.remove(i)

    def __getitem__(self, i):
        return self._data[i]
    
    def reset(self): # debugging only
        self._data = IOSet()        
        
        

        
