"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.ObjectManager import ObjectManager
from Products.EventChannel.eventchannel import get_uid


## container managed events

class FolderEventSource:

    def _setObject(self, id, object, roles=None, user=None, set_owner=1):

        ObjectManager._setObject(self, id, object, roles, user, set_owner)
        obj = getattr(self, id)
        ec = self.get_event_channel()
        ec.publish(obj, "object added", get_uid(self))        

    def _delObject(self, id):

        obj = getattr(self, id)
        self.get_event_channel().publish(obj, "object deleted", get_uid(self))
        ObjectManager._delObject(self, id)
        
    def manage_afterAdd(self, item, container):
        ec = self.get_event_channel()
        ec.register_source(self, "object added")
        ec.register_source(self, "object deleted")

## object managed events        

class ObjectEventSource:
    
    def manage_afterAdd(self, item, container):
        ec = self.get_event_channel()
        ec.register_source(self, "object added")
        ec.register_source(self, "object deleted")
        ec.register_source(self, "object cloned")
        ec.publish(self, "object added")
        
    def manage_afterClone(self, item):
        ec = self.get_event_channel()
        ec.publish(self, "object cloned")
        
    def manage_beforeDelete(self, item, container):
        ec = self.get_event_channel()
        ec.publish(self, "object deleted")
