# Author: Kapil Thangavelu <kvthan@wm.edu>
# License: GPL <www.gnu.org>
# CVS: $Id: IEventChannel.py,v 1.1.1.1 2001/12/31 04:07:06 ender Exp $

from Interface import Base

class IEventChannel(Base):
    
    def register_event_type(self, event_type):
        """ register event_type as a new event channel,
       event_type should be a string. raises error
      if event_type is not a string."""
        
    def unregister_event_type(self, event_type):
        """ removes an event_type from the event channel"""
    
    def has_event_type(self, event_type):
        """ """
        
    def get_event_types(self):
        """ """
        
    def register_listener(self, object, method, event_type, filter=None):
        """
        registers obj which implements the IEventDiscoverable interface
        with the event channel as a listener for event_type. 
        filter is a callable object which may be acquired from object or 
        an External method which implements the IEventTarget interface, 
        it is called prior to calling the object and if true the 
        'method' of object is called, method should be a actual method
        of the object which implements the IEventTarget interface.
        
        be aware that publishing is a depth first algorithm.
        """       
        
    def unregister_listener(self, object, event_type=None):
        """
        unregisters an object from the event channel, if event_type
        is None than the object is removed from all event_types else
        only the event_type specified 
        """
        
    def is_listener(self, object):
        """
        returns 1/0 depending on whether object is a registered
        listener with the event_channel
        """
        
    def get_event_listeners(self):
        """ returns all event_listeners uids"""

    def get_event_types_for_listener(self, object):
        """
        returns all the event_types (a list) for which this
        object is regisered as a listener
        """
        
    def set_listener_filter_for_event_type(self, object, filter, event_type):
        """
        
        """

    def register_source(self, object, event_type):
        """
        registers object which implmenents the IEventDiscoverable interface
        as a source for event_type
        """
        
    def unregister_source(self, object, event_type):
        """ 
        unregisters object as a source for event_type
        """

    def get_event_sources(self):
        """
        returns uids for all registered sources
        """
        
    def is_source(self, object):
        """
        returns 1/0 depending on whether object is a registered
        event source """
        
        
    def publish(self, obj, event_type, sid=None):
        """ publish obj on channel event_type if obj is a proxy for
        an event source than sid should be the source objects uid.
        methods for generating uids should get exposed via Event Channel..."""
        
    def clear_event_channel(self):
        """ armageddon, resets the event_channel clearing out all registrations """

    def sync_registrations(self):
        """ removes registrations to unreachable objects """
    	
