from Acquisition import Implicit

# this is a bit of a hack so we get special users defined
import AccessControl.User

class BaseRoot(Implicit):

    def __init__(self):
        self._paths = {}

    def addObject(self, object):
        setattr(self, object.id, object)
        self._paths[object.path]=object

    def unrestrictedTraverse(self, path):
        return self._paths[path]

    def getPhysicalRoot(self):
        return self

    def __getitem__(self, name):
        return getattr(self, name)

class BasePath:

    def __init__(self,id, path):
        self.id = id
        self.path = tuple(path.split('/'))

    def getPhysicalPath(self):
        return self.path

    def __getitem__(self, name):
        return getattr(self, name)

class BasicEventSource(Implicit, BasePath):

    _type = 'Foo'
    
    def broadcast(self):
        self.channel.publish(self._type, self)

class BasicEventListener(Implicit, BasePath):

    def listen(self, *args):
        self.heard = 1
        
class BasicEventFilter(Implicit, BasePath):

    def __init__(self, id, path, result):
        self.id = id
        self.path = path
        self.result = result

    def __call__(self, *args): return self.result

class Proxy(Implicit): pass

class ProxyEventSource(Implicit, BasePath):

    _type = 'Bar'

    def broadcast(self):
        self.channel.publish(self._type, Proxy())
