from BTrees.IOBTree import IOBTree
from BTrees.OIBTree import OIBTree

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Logs import LogFactory
from Products.Gideon.Objects.Application.PythonRepository 


log = LogFactory('NewsSink')

class DuplicateChannel(Exception): pass

class NewsSink(RepositoryApplication):
    
    meta_type = 'News Sink'

    def __init__(self, id):
        self.id = id
        self._rss_channels = IOBTree()
        self._active_channels = OIBTree()

    def add_channel(self, channel_name, channel_uri, active=1):
        
        channel_id = hash(channel_name)
        
        if self._rss_channels.has_key(channel_id):
            
            raise DuplicateChannel( "Channel with this name already exists")
        
    def remove_channel(self, channel_name):
        
        channel_id = hash(channel_name)
        
        if self._rss_channels.has_key(channel_id):

            unindex = self.get_service('ItemCatalog').uncatalog_object
            channel = self._rss_channels[channel_id].__of__(self)
            
            map(unindex, channel.get_items())
                
            if self._active_channels.has_key(channel_name):
                del self._active_channels[channel_name]
                
            del self._rss_channels[channel_id]

class IChannel(SimpleItem):
    
    def get_history(self):
        pass
    
    def refresh(self):
        pass

    def __bobo_traverse__(self, REQUEST, name):
        pass

class Channel:
    pass

class RSSChannel(Channel):     
