
from ZODB.PersistentMapping import PersistentMapping

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Objects.Application.PythonRepository import RepositoryApplication
from Products.Gideon.Log.Log import log

from RSSHandler import RSSHandler
       
from xml.sax import make_parser
import urllib

import string
from os import path

class ChannelItem(SimpleItem):

    meta_type = 'Channel Item'
        
    index_html = DTMLFile('ui/ChannelItemView', globals())
    call_view  = DTMLFile('ui/ChannelItemCallView', globals())
    
    def __init__(self, id):
        self.id = id
        self._info = PersistentMapping()

    def title(self):

        return self._info.get('Title','')

    def link(self):

        return self._info.get('Link','')    

    def description(self): return self._info.get('Description','')    
        
    def _set_item_info(self, info):
        self._info.update(info)
        
    def __call__(self):
        return self.call_view(self, self.REQUEST)
        
        
class Channel(Folder):
    
    meta_type = 'Channel'

    index_html = DTMLFile('ui/ChannelView',globals())
    channel_widget = DTMLFile('ui/ChannelWidget', globals())
    
    def __init__(self, id):
        self.id = id
        self.data = PersistentMapping()
        
    def set_source_url(self, url):
        self.data['url'] = url
        
    def refresh_from_source(self):
        """ """
        log.debug('refreshing %s'%self.getId())
        
        url = self.data.get('url', '')
        if not url: return

        # we save local files for debugging
        savefile = path.join(package_home(globals()), 'var', self.getId())     

        try:
            # mime contains an open fp
            filename, mime= urllib.urlretrieve(url, savefile)
            fh = open(savefile, 'r')
        except Exception, e:
            log.warning("can't retrieve channel url: %s"%str(e))
            raise

        ch = RSSHandler()
        p = make_parser()
        p.setContentHandler(ch)
        p.parse(fh)
        fh.close()

        log.debug('done parsing')
        
        info = ch.getInfo()

        item_info = info.get('Item', None)
        if item_info is None:
            item_info = info.get('Channel')['Item']
            del info['Channel']['Item']

        info = info.get('Channel')
        
        log.debug('info %s'%str(info))

        items = item_info

        log.debug('info2 %s'%str(info))

        try:
            if isinstance(info, type([])):
                self.data.update(info.pop())
            else:
                self.data.update(info)
        except:
            print info, self.getId()
        
        # we just blast away old items...
        self.manage_delObjects(self.objectIds('Channel Item'))
        
        for i in xrange(len(items)):
            ci = ChannelItem(str(i))
            if not items[i].get('Link'): print 'nope' ; continue
            try: ci._set_item_info(items[i])
            except: continue 
            self._setObject(str(i), ci)
   
class NewsSink(RepositoryApplication):
    """
    A Simple RSS Channel Manager
    """
    
    meta_type = 'News Sink'

    
    index_html = None
    
    __call__ = DTMLFile('ui/NewsSinkView',globals())
    
    news_widget = DTMLFile('ui/NewsSinkWidget',globals())
    
    def __init__(self, id):
        self.id = id
        
    def reset(self, REQUEST): 
        """ """
        log.debug('refreshing channels')
        self.refresh_channels()
        
        REQUEST.RESPONSE.redirect('.')
    
    def add_channel(self, id, channel_url):
        ob = Channel(id)
        ob.set_source_url(channel_url)
        self._setObject(id, ob)
        
    def remove_channel(self, channel_id):
        self.delObjects(channel_id)
    
    def get_channel(self, channel_id):
        self._getOb(channel_id)

    def set_channel_active(self, channel_id):
        ob = self._getOb(channel_id)
        ob.active = 1

    def get_active_channels(self):
        
        return self.PythonCookbook, self.ZopeNews
    
    def refresh_channels(self):
        """ """
        channels = self.objectValues('Channel')
        for c in channels: 
            try: c.refresh_from_source()
            except: pass

    def _set_active_defaults(self):
        """ calling this method seems to cause some seriously bad voodoo.
        basically it causes zserver to throw exceptions with mozilla,
        which is beyond me. its magic """
        
        for ob in self.objectValues('Channel'):
            if ob.getId() in ('ZopeNews', 'PythonCookbook', 'FreshMeat'):
                ob.active = 1
            else:
                ob.active = 0
        
    def _import_defaults(self):
        
        home = package_home(globals())
        default_file = path.join(home, 'default_channels.txt')
        fh = open(default_file)
        for l in fh.xreadlines():
            l = l.strip()
            id, url = map(string.strip, l.split('='))
            self.add_channel(id, url)
            
