"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

# $Id: SaxDocumentHandlers.py,v 1.1.1.1 2001/12/31 04:07:06 ender Exp $
# Licensed under the LGPL @gnu.org
# Created by: Kapil Thangavelu (k_vertigo@yahoo.com)
#

from xml.sax import ContentHandler
import time
        
class OCSBase(ContentHandler):

    """
    A Sax2 Handler for the Open Content Syndication Format (ocs).

    more information on ocs can be found at
    http://alchemy.openjava.org/ocs/
    
    
    @author Kapil Thangavelu
    @author k_vertigo@yahoo.com
    
    """

    def __init__(self):

        # state flags
        self.inChannel = 0
        self.inItem = 0
        self.inTitle = 0
        self.inLanguage = 0
        self.inFormat = 0
        self.inCreator = 0
        self.inDescription = 0
        self.inSubject = 0
        self.inLink = 0
        self.inContentType = 0
        self.inUpdateFrequency = 0
        self.inUpdatePeriod = 0
        self.inImage = 0
        
        # data collection structs
        self.ItemInfo = {'Title':'', 'Description':'', 'Links':[], 'Creator':'',
                         'Url':'', 'Subject':'', 'Image':''}
        
        self.Link = {'Url':'', 'Language':'', 'Format':'', 'ContentType':'',
                     'UpdatePeriod':'', 'UpdateFrequency':''}
        
        self.ChannelInfo = {'Title':'', 'Url':'', 'Creator':'',
                            'Description':'', 'Items':[]}

        # bookkeeping
        self.time = 0
        
    def startElement(self, name, attrs):

        if name == 'rdf:description':
            if self.inChannel:
                if self.inItem:
                    self.startLink(name,attrs)
                else:
                    self.startItem(name,attrs)
            else:
                self.startChannel(name,attrs)
                
        elif name == 'dc:title':
            self.startTitle(name,attrs)            
        elif name == 'dc:creator':
            self.startCreator(name,attrs)
        elif name == 'dc:description':
            self.startDescription(name,attrs)
            
        elif name =='dc:subject': 
            self.startSubject(name,attrs)
            
        elif name == 'dc:language':
            self.startLanguage(name,attrs)
        elif name == 'ocs:format':
            self.startFormat(name,attrs)
            
        elif name == 'ocs:updateFrequency':
            self.startUpdateFrequency(name,attrs)
        elif name == 'ocs:updatePeriod':
            self.startUpdatePeriod(name,attrs)
        elif name == 'ocs:contentType':
            self.startContentType(name,attrs)
        elif name == 'ocs:image':
            self.startImage(name,attrs)
        
        elif name == 'rdf:RDF':
            pass # anyone want to collect namespaces...
        
        else:
            print "uncaught", name, attrs
            raise "foo"
            

    def endElement(self, name):
        if name == 'rdf:description':
            if self.inChannel:
                if self.inItem and self.inLink:
                    self.endLink(name)
                elif self.inItem:
                    self.endItem(name)
                else:
                    self.endChannel(name)
        elif name == 'dc:title':
            self.endTitle(name)
        elif name == 'dc:creator':
            self.endCreator(name)
        elif name == 'dc:description':
            self.endDescription(name)
        elif name == 'dc:subject':
            self.endSubject(name)
        elif name == 'dc:language':
            self.endLanguage(name)
        elif name == 'ocs:format':
            self.endFormat(name)
        elif name == 'ocs:updatePeriod':
            self.endUpdatePeriod(name)
        elif name == 'ocs:updateFrequency':
            self.endUpdateFrequency(name)
        elif name == 'ocs:contentType':
            self.endContentType(name)
        elif name == 'ocs:image':
            self.endImage(name)
                    
    def startChannel(self, name, attrs):        

        self.time = time.time()
        self.inChannel = 1
        self.ChannelInfo['Url']= attrs['about']

    def endChannel(self, name):
        print "Done Parsing OCS Channel in ", time.time() - self.time
        self.inChannel = 0

    def startItem(self, name, attrs):

        self.inItem = 1
        self.ItemInfo['Url'] = attrs['about']

    def endItem(self, name):
        self.inItem = 0
        self.ChannelInfo['Items'].append(self.ItemInfo)
        self.ItemInfo = {'Title':'', 'Description':'', 'Links':[], 'Creator':'',
                         'Url':'', 'Subject':'', 'Image':''}

    def startLink(self, name, attrs):
        self.inLink = 1
        self.Link['Url']=attrs['about']

    def endLink(self, name):
        self.inLink = 0
        self.ItemInfo['Links'].append(self.Link)
        self.Link = {'Url':'', 'Language':'', 'Format':'', 'ContentType':'',
                     'UpdatePeriod':'', 'UpdateFrequency':''}
        
    def startCreator(self, name, attrs):
        self.inCreator = 1

    def endCreator(self, name):
        self.inCreator = 0

    def startTitle(self, name, attrs):
        self.inTitle = 1

    def endTitle(self, name):
        self.inTitle = 0

    def startFormat(self, name, attrs):
        self.inFormat = 1

    def endFormat(self, name):
        self.inFormat = 0

    def startLanguage(self, name, attrs):
        self.inLanguage = 1
    
    def endLanguage(self, name):
        self.inLanguage = 0

    def startDescription(self, name,attrs):
        self.inDescription = 1

    def endDescription(self, name):
        self.inDescription = 0

    def startSubject(self, name, attrs):
        self.inSubject = 1

    def endSubject(self, name):
        self.inSubject = 0

    def startImage(self,name,attrs):
        self.inImage = 1

    def endImage(self, name):
        self.inImage = 0

    def startUpdatePeriod(self, name, attrs):
        self.inUpdatePeriod = 1

    def endUpdatePeriod(self, name):
        self.inUpdatePeriod = 0

    def startUpdateFrequency(self, name, attrs):
        self.inUpdateFrequencey = 1
        
    def endUpdateFrequency(self, name):
        self.inUpdateFrequencey = 0

    def startContentType(self, name, attrs):
        self.inContentType = 1

    def endContentType(self, name):
        self.inContentType = 0
    
    def characters(self, content):

        if self.inChannel:
            if self.inItem:
                if self.inLink:
                    if self.inLanguage:
                        self.Link['Language']=self.Link['Language']+content
                    elif self.inContentType:
                        self.Link['ContentType']=self.Link['ContentType']+content
                    elif self.inUpdateFrequency:
                        self.Link['UpdateFrequency']=self.Link['UpdateFrequency']+content
                    elif self.inUpdatePeriod:
                        self.Link['UpdatePeriod']=self.Link['UpdatePeriod']+content
                    elif self.inFormat:
                        self.Link['Format']=self.Link['Format']+content
                        
                elif self.inTitle:
                    self.ItemInfo['Title']=self.ItemInfo['Title']+content
                elif self.inCreator:
                    self.ItemInfo['Creator']=self.ItemInfo['Creator']+content
                elif self.inDescription:
                    self.ItemInfo['Description']=self.ItemInfo['Description']+content
                elif self.inSubject:
                    self.ItemInfo['Subject']=self.ItemInfo['Subject']+content
                elif self.inImage:
                    self.ItemInfo['Image']=self.ItemInfo['Image']+content
                    
            elif self.inTitle:
                self.ChannelInfo['Title']=self.ChannelInfo['Title']+content
            elif self.inCreator:
                self.ChannelInfo['Creator']=self.ChannelInfo['Creator']+content
            elif self.inDescription:
                self.ChannelInfo['Description']=self.ChannelInfo['Description']+content
                            
                                    
    def getValues(self):
        return self.ChannelInfo

    def reset(self):
        self.__init__()


        
   
