import unittest
import sys
import os

sys.path.append(os.path.abspath(os.pardir))

import SaxDocumentHandlers
from xml import sax

class RSSSaxParseTest(unittest.TestCase):

	def setUp(self):
		self.parser = sax.make_parser()
		self.parser.setContentHandler(SaxDocumentHandlers.RSS())
	def tearDown(self):
		del self.parser

	def testNewsForgeRssFile(self):
		self.parser.parse('data/rss/newsforge.rss')
		
		ch = self.parser.getContentHandler()
		print ch.getValues()
		ch.reset()


		

class OCSSaxParseTest(unittest.TestCase):
	
	def setUp(self):
		self.parser = sax.make_parser()	    
		self.parser.setContentHandler(SaxDocumentHandlers.OCSBase())
		
	def tearDown(self):
		del self.parser
	    
	def testSmallOcsFile(self):
		""" Checking OCS Sax2 Handler on small OCS file """
		self.parser.parse('data/ocs/xml_tree_ocs.xml')

		ch = self.parser.getContentHandler()
		ch.getValues()
		ch.reset()

	def testMoreoverOcsFile(self):
		""" Checking OCS Sax2 Handler on OCS file from moreover.com """
		
		self.parser.parse('data/ocs/moreover_ocs.xml')

		ch = self.parser.getContentHandler()
		ch.getValues()
		ch.reset()
	
	def testScriptingNewsOcsFile(self):
		""" Checking OCS Sax2 Handler on OCS file of scripting.com
		channels """

		self.parser.parse('data/ocs/scriptingnews_ocs.xml')
		ch = self.parser.getContentHandler()
		ch.getValues()
		ch.reset()
				

def make_rss_suite():
	rsssuite = unittest.TestSuite()
	rsssuite.addTest(RSSSaxParseTest("testNewsForgeRssFile"))
	return rsssuite

def make_ocs_suite():
	ocssuite = unittest.TestSuite()
	ocssuite.addTest(OCSSaxParseTest("testSmallOcsFile"))
	ocssuite.addTest(OCSSaxParseTest("testMoreoverOcsFile"))
	ocssuite.addTest(OCSSaxParseTest("testScriptingNewsOcsFile"))
	return ocssuite

def make_core_suite():
	csuite = unittest.TestSuite()
	csuite.addTest(make_ocs_suite())
	csuite.addTest(make_rss_suite())
	
	return csuite	
	
if __name__ == '__main__':
	runner = unittest.TextTestRunner()
	runner.run(make_core_suite())
	







 
