from Persistence import Persistent

from BTrees.IOBTree import IOBTree
from BTrees.OIBTree import OIBTree
from BTrees.IIBTree import IISet

from Products.PluginIndexes.common.randid import randid

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log.Log import LogFactory

from ApplicationObject import ApplicationObject

log = LogFactory("Object Linking Service")

class ObjectLinkingService(SimpleItem, ApplicationObject):

    def _v_next_oid(self):
        """
        we duplicate the same oid generation
        that zcat uses, namely we want
        generally sequentially indexes within
        a given thread, so we allocate blocks
        of numbers from a random start
        for a  given thread
        """
        self._v_next_oid = oid = randind()
        return oid

    _v_next_oid = ComputedAttribute(_v_next_oid)

    def __init__(self, id, title=''):
        self.id = id
        self.title = title
        self.paths = OIBTree()
        self.oids  = IOBTree()
        #self.removed = IOBTree() 
        #self.deleted = IOBTree()
        self._errors = 0 # behavior for error conditions

    def generate_oid(self):
        
        oid = self._v_next_oid
        if oid%5000 == 0:
            oid = randid()        
        self._v_next_oid = oid+1
        return oid
        
    def get_reference(self, object):
        
        log.debug("creating object reference")

        path = '/'.join(object.getPhysicalPath())

        oid = self.paths.get(path, None)
        
        if oid is not None: return ObjectReference(oid)

        oid = self.generate_oid()
        
        self.oids[oid]=path
        self.paths[path]=oid

        return ObjectReference(oid)

    def remove_reference(self, object):
        
        path = '/'.join(object.getPhysicalPath())
        
        log.debug("removing object reference %s"%path)

        oid =  self.paths.get(path, None) is n

        if oid is not None:
            self.removed[oid]=path

    def get_object(self, oid):

        path = self.oids.get(oid, None)

        log.debug("retrieving object reference %s"%str(path))

        if path is None:
            if self.removed.has_key(oid):
                raise ObjectRemovedError(
                    "object removed from the linking service"
                    )
            elif self.deleted.has_key(oid):
                raise ObjectDeletedError(
                    "object deleted"
                    )
                
            raise ObjectLookupError(
                "Inconsistent Linking State No Path for Oid %d"%oid
                )

        try:
            object = self.unrestrictedTraverse(path)
        except:

        
        return object

    def update_reference_deleted(self, reference):

        path = self.oids.get(reference.oid, None)
        
        if path is not None:
            # send out notifications
            
            self.deleted[reference.oid]=path
            del self.oids[reference.oid]
            del self.paths[path]

    def update_reference_moved(self, reference, new_path):

        if self.oids.get(reference.oid, None) is not None:
            self.oids[reference.oid] = new_path

    def manage_afterAdd(self, item, container):
        channel = self.get_service("EventChannel")
        # register the event types

        # including types for reference listeners
        # add in special filters for event_listeners

        # register the linker as a listener to those event types


class Reference(Implicit):
    """ store event notifications """

class ObjectReference(Persistent, Implicit):

    def __init__(self, oid):
        self.oid = oid
        
    def __getstate__(self):
        return self.oid

    def __setstate__(self, oid):
        self.oid = oid

    def get_object(self):
        ols = self.get_service('ObjectLinking')
        return ols.get_object(self)

    """ ## later
    def notify(self, method, for_all_events=0):

        notify the references container
        when the reference is deleted or
        if all_events is true when the
        object is moved also. containers
        need to obtain wrapped object
        references before calling listen.
        method should be a string that
        denotes a method to call on the object
    
        listener = self.aq_inner.aq_parent
    """        

    __call__ = get_object
        

class ObjectLookupError(AttributeError): pass

class ObjectRemovedError(AttributeError): pass

class ObjectDeleteError(AttributeError): pass

class ObjectSet(IISet): pass

    

