
"""
Gideon.Objects.Packages.Package.py

The Package Object and friends

Author: Kapil Thangavelu
License: GPL
CVS: $Id: Package.py,v 1.1.1.1 2001/12/31 04:07:06 ender Exp $

"""

from OFS.Image import cookId

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Objects.Ratings.Ratings import Rating
from Products.Gideon.Log.Log import log
from Products.Gideon.PageContract.Scripts import compile
from Products.Gideon.Objects.Authors.Authors import Author, make_author_id

from PackageFile import PackageFile
from PackageVersion import PackageVersionContainer, PackageVersion
from PackageDependency import PackageDependency
from PackageHistory import PackageHistory
from PackageStateVariables import PackageStateVariables
from PackageAdmin import PackageAdmin

class NullPresentation:
    
    __allow_access_to_unprotected_subobjects = 1
    
    def __call__(self): return ''

class Package(Folder):

    security = ClassSecurityInfo()
    
    meta_type = 'Package' 
    
    index_html = DTMLFile('ui/PackageView', globals())

    def __init__(
        self, 
        id='', 
        title=''
        ):

        self.id =id
        self.title = title
        self._published = 0 ## denotes whether we fire events for
                            ## version additions
        self._initialized = 0

    security.declarePublic('get_package_admin')
    def get_package_admin(self):
        return self._getOb('Admin')

    security.declarePublic('get_version_container')
    def get_version_container(self):
        return self._getOb('Versions')

    security.declarePublic('get_package_info')
    def get_package_info(self):
        return getattr(self, 'info')

    security.declarePrivate('set_package_info')
    def set_package_info(self, pi):
        self._setObject('info', pi)

    security.declarePublic('get_platforms')
    def get_platforms(self):
        # should iterate through version container
        return ('all')

    security.declarePublic('is_published')
    def is_published(self):
        """  """
        return self._published

    security.declarePrivate('set_published')
    def set_published(self, published):        
        
        if published and not self._published:
            self.published_initialized()
            
        self._published = published            

    security.declarePublic('get_ratings')
    def get_ratings(self):
        if self._published:
            return self._getOb('Ratings')
        return NullPresentation()

    security.declarePublic('get_reviews')
    def get_reviews(self):
        if self._published:
            pass
        return NullPresentation()

    security.declarePublic('get_state_id')
    def get_state_id(self):
        return self._state

    security.declarePublic('get_history')    
    def get_history(self):
        return self._getOb('History')

    security.declarePrivate('get_state_vars')    
    def get_state_vars(self):
        return self._getOb('StateVars')
    
    security.declarePublic('get_package')    
    def get_package(self):
        return self

    def _initialize(self):
        '''  we set state here so the package
        can be stored in the session? '''
        self._state = 'uploaded'
        self._setObject('Versions', PackageVersionContainer('Versions'))
        self._setObject('Admin', PackageAdmin('Admin'))		
        self._setObject('History', PackageHistory('History'))
        self._setObject('StateVars', PackageStateVariables('StateVars'))
                        
        self._initialized = 1
        
    security.declarePrivate('published_initialized')
    def published_initialized(self): 
        ''' '''
        self._setObject('Ratings', Rating('Ratings'))

        self._published = 1

    security.declarePublic('get_review')        
    def manage_afterAdd(self, item, container):
        if not self._initialized:
            self._initialize()

InitializeClass(Package)

